/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.treeStructure.PatchedDefaultMutableTreeNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import java.awt.EventQueue;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class SimpleTreeBuilder
extends AbstractTreeBuilder {
    public SimpleTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator comparator) {
        super(tree, treeModel, treeStructure, comparator);
    }

    public boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return ((SimpleNode)nodeDescriptor).isAlwaysShowPlus();
    }

    public boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return ((SimpleNode)nodeDescriptor).isAutoExpandNode();
    }

    public final void updateFromRoot() {
        this.updateFromRoot(false);
    }

    public void updateFromRoot(boolean rebuild) {
        if (rebuild) {
            this.cleanUpStructureCaches();
        }
        if (EventQueue.isDispatchThread()) {
            SimpleTreeBuilder.super.updateFromRoot();
        } else {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                public void run() {
                    SimpleTreeBuilder.super.updateFromRoot();
                }
            });
        }
    }

    protected final DefaultMutableTreeNode createChildNode(NodeDescriptor childDescr) {
        return new PatchedDefaultMutableTreeNode(childDescr);
    }

    private void cleanUpStructureCaches() {
        if (!(this.myTreeStructure instanceof SimpleTreeStructure)) {
            return;
        }
        ((SimpleTreeStructure)this.myTreeStructure).clearCaches();
    }

    public SimpleTreeBuilder initRoot() {
        this.initRootNode();
        return this;
    }
}

