/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.peer.PeerFactory;
import com.intellij.ui.UIHelper;
import com.intellij.ui.treeStructure.NullNode;
import com.intellij.ui.treeStructure.PatchedDefaultMutableTreeNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleNodeRenderer;
import com.intellij.ui.treeStructure.SimpleNodeVisitor;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class SimpleTree
extends JTree
implements CellEditorListener {
    protected final MouseListener myMouseListener = new MyMouseListener();
    private ActionGroup myPopupGroup;
    private String myPlace;
    private static final SimpleNode NULL_NODE = new NullNode();
    private static final int INVALID = -1;
    private JComponent myEditorComponent;
    private boolean myEscapePressed;
    private int myEditingRow;
    private boolean myIgnoreSelectionChange;
    private int myMinHeightInRows = 5;

    public SimpleTree() {
        this.setModel(new DefaultTreeModel(new PatchedDefaultMutableTreeNode()));
        TreeUtil.installActions(this);
        UIHelper helper = PeerFactory.getInstance().getUIHelper();
        helper.installTreeSpeedSearch(this);
        helper.installToolTipHandler(this);
        this.addMouseListener(this.myMouseListener);
        this.setCellRenderer(new SimpleNodeRenderer());
        this.setEditable(false);
        this.getSelectionModel().setSelectionMode(4);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                if (!SimpleTree.this.myIgnoreSelectionChange && SimpleTree.this.hasSingleSelection()) {
                    SimpleTree.this.getNodeFor(SimpleTree.this.getSelectionPath()).handleSelection(SimpleTree.this);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && SimpleTree.this.hasSingleSelection()) {
                    SimpleTree.this.handleDoubleClickOrEnter(SimpleTree.this.getSelectionPath(), e);
                }
                if (e.getKeyCode() == 113 && e.getModifiers() == 0) {
                    e.consume();
                }
            }
        });
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setUI(new BasicTreeUI());
    }

    public SimpleTree(TreeModel aModel) {
        this();
        this.setModel(aModel);
    }

    public boolean accept(AbstractTreeBuilder builder, SimpleNodeVisitor visitor) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        return SimpleTree.visitDown(builder, (SimpleNode)root.getUserObject(), visitor);
    }

    public void setPopupGroup(ActionGroup aPopupGroup, String aPlace) {
        this.myPopupGroup = aPopupGroup;
        this.myPlace = aPlace;
    }

    public SimpleNode getNodeFor(int row) {
        return this.getNodeFor(this.getPathForRow(row));
    }

    public SimpleNode getNodeFor(TreePath aPath) {
        if (aPath == null) {
            return NULL_NODE;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)aPath.getLastPathComponent();
        if (treeNode == null) {
            return NULL_NODE;
        }
        Object userObject = treeNode.getUserObject();
        if (userObject instanceof SimpleNode) {
            return (SimpleNode)userObject;
        }
        return NULL_NODE;
    }

    @Nullable
    public TreePath getPathFor(SimpleNode node) {
        DefaultMutableTreeNode nodeWithObject = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)this.getModel().getRoot(), node);
        if (nodeWithObject != null) {
            return TreeUtil.getPathFromRoot(nodeWithObject);
        }
        return null;
    }

    @Nullable
    public SimpleNode getSelectedNode() {
        if (this.isSelectionEmpty()) {
            return null;
        }
        return this.getNodeFor(this.getSelectionPath());
    }

    public boolean isSelectionEmpty() {
        TreePath selection = super.getSelectionPath();
        return selection == null || this.getNodeFor(selection) == NULL_NODE;
    }

    public SimpleNode[] getSelectedNodesIfUniform() {
        ArrayList<SimpleNode> result = new ArrayList<SimpleNode>();
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            Object lastNode = null;
            for (TreePath selectionPath : selectionPaths) {
                SimpleNode nodeFor = this.getNodeFor(selectionPath);
                if (lastNode != null && lastNode.getClass() != nodeFor.getClass()) {
                    return new SimpleNode[0];
                }
                result.add(nodeFor);
                lastNode = nodeFor;
            }
        }
        return result.toArray(new SimpleNode[result.size()]);
    }

    public void setSelectedNode(AbstractTreeBuilder builder, SimpleNode node, boolean expand) {
        SimpleNode selectedNode;
        TreePath selected = this.getSelectionPath();
        if (selected != null && (selectedNode = this.getNodeFor(selected)).equals(node)) {
            return;
        }
        if (expand) {
            builder.buildNodeForElement(node);
        }
        TreePath path = this.getPathFor(node);
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    private static boolean visitDown(AbstractTreeBuilder builder, SimpleNode node, SimpleNodeVisitor visitor) {
        Object[] children;
        if (visitor.accept(node)) {
            return true;
        }
        for (Object aChildren : children = builder.getTreeStructure().getChildElements(node)) {
            if (!SimpleTree.visitDown(builder, (SimpleNode)aChildren, visitor)) continue;
            return true;
        }
        return false;
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        g.setColor(UIManager.getColor("Tree.line"));
        for (int row = 0; row < this.getRowCount(); ++row) {
            TreePath path = this.getPathForRow(row);
            if (!this.getNodeFor(path).shouldHaveSeparator()) continue;
            Rectangle bounds = this.getRowBounds(row);
            int x = (int)bounds.getMaxX();
            int y = (int)(bounds.getY() + (double)(bounds.height / 2));
            g.drawLine(x, y, this.getWidth() - 5, y);
        }
    }

    public void doClick(int row) {
        this.setSelectionRow(row);
    }

    public void cancelEditing() {
        if (this.isEditing()) {
            this.cellEditor.cancelCellEditing();
            this.doStopEditing();
        }
    }

    public void editingStopped(ChangeEvent e) {
        this.doStopEditing();
    }

    public void editingCanceled(ChangeEvent e) {
        this.doStopEditing();
    }

    public JComponent getEditorComponent() {
        return this.myEditorComponent;
    }

    public boolean isEditing() {
        return this.myEditorComponent != null;
    }

    public TreePath getEditingPath() {
        if (this.isEditing()) {
            return this.getPathForRow(this.myEditingRow);
        }
        return super.getEditingPath();
    }

    public boolean isPathEditable(TreePath path) {
        return true;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isEditing()) {
            Rectangle editedNodeRect = this.getRowBounds(this.myEditingRow);
            if (editedNodeRect == null) {
                return;
            }
            g.setColor(this.getBackground());
            g.fillRect(editedNodeRect.x, editedNodeRect.y, editedNodeRect.width, editedNodeRect.height);
        }
    }

    public void setCellEditor(TreeCellEditor aCellEditor) {
        if (this.cellEditor != null) {
            this.cellEditor.removeCellEditorListener(this);
        }
        super.setCellEditor(aCellEditor);
        if (this.cellEditor != null) {
            this.cellEditor.addCellEditorListener(this);
        }
    }

    public boolean stopEditing() {
        boolean result = this.isEditing();
        if (result) {
            if (!this.cellEditor.stopCellEditing()) {
                this.cellEditor.cancelCellEditing();
            }
            this.doStopEditing();
        }
        return result;
    }

    public void startEditingAtPath(TreePath path) {
        if (path != null && this.isVisible(path)) {
            if (this.isEditing() && !this.stopEditing()) {
                return;
            }
            this.startEditing(path);
        }
    }

    private void startEditing(final TreePath path) {
        TreeCellEditor editor = this.getCellEditor();
        if (editor != null && editor.isCellEditable(null) && this.isPathEditable(path)) {
            this.getSelectionModel().clearSelection();
            this.getSelectionModel().setSelectionPath(path);
            this.myEditingRow = this.getRowForPath(path);
            this.myEditorComponent = (JComponent)this.getCellEditor().getTreeCellEditorComponent(this, path.getLastPathComponent(), this.isPathSelected(path), this.isExpanded(path), this.treeModel.isLeaf(path.getLastPathComponent()), this.myEditingRow);
            this.putEditor(path);
            if (this.myEditorComponent.isFocusable()) {
                this.myEditorComponent.requestFocusInWindow();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SimpleTree.this.scrollPathToVisible(path);
                }
            });
        }
    }

    private void putEditor(TreePath path) {
        this.add(this.myEditorComponent);
        Rectangle nodeBounds = this.getPathBounds(path);
        Dimension editorPrefSize = this.myEditorComponent.getPreferredSize();
        if (editorPrefSize.height > nodeBounds.height) {
            nodeBounds.y -= (editorPrefSize.height - nodeBounds.height) / 2;
            nodeBounds.height = editorPrefSize.height;
        }
        this.myEditorComponent.setBounds(nodeBounds);
        this.myEscapePressed = false;
    }

    private void doStopEditing() {
        if (this.isEditing()) {
            this.remove(this.myEditorComponent);
            this.myEditorComponent = null;
            this.setSelectionRow(this.myEditingRow);
            this.myEditingRow = -1;
            this.repaint();
        }
    }

    public boolean isEscapePressed() {
        return this.myEscapePressed;
    }

    public void setEscapePressed() {
        this.myEscapePressed = true;
    }

    public void addSelectionPath(TreePath path) {
        this.myIgnoreSelectionChange = true;
        super.addSelectionPath(path);
        this.myIgnoreSelectionChange = false;
    }

    public void addSelectionPaths(TreePath[] path) {
        this.myIgnoreSelectionChange = true;
        super.addSelectionPaths(path);
        this.myIgnoreSelectionChange = false;
    }

    private boolean isSelected(TreePath path) {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                if (!path.equals(selectionPath)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMultipleSelection() {
        return this.getSelectionRows() != null && this.getSelectionRows().length > 1;
    }

    private void handleDoubleClickOrEnter(final TreePath treePath, final InputEvent e) {
        Runnable runnable = new Runnable(){

            public void run() {
                SimpleTree.this.getNodeFor(treePath).handleDoubleClickOrEnter(SimpleTree.this, e);
            }
        };
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.stateForComponent(this));
    }

    public static boolean isDoubleClick(MouseEvent e) {
        return e != null && e.getClickCount() > 0 && e.getClickCount() % 2 == 0;
    }

    protected ActionGroup getPopupGroup() {
        return this.myPopupGroup;
    }

    protected void invokeContextMenu(final MouseEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu(SimpleTree.this.myPlace, SimpleTree.this.myPopupGroup);
                menu.getComponent().show(e.getComponent(), e.getPoint().x, e.getPoint().y);
            }
        });
    }

    public boolean select(AbstractTreeBuilder aBuilder, final SimpleNodeVisitor aVisitor, boolean shouldExpand) {
        final SimpleNode[] found = new SimpleNode[1];
        boolean wasFound = this.accept(aBuilder, new SimpleNodeVisitor(){

            public boolean accept(SimpleNode simpleNode) {
                if (aVisitor.accept(simpleNode)) {
                    found[0] = simpleNode;
                    return true;
                }
                return false;
            }
        });
        if (wasFound) {
            this.setSelectedNode(aBuilder, found[0], shouldExpand);
        }
        return wasFound;
    }

    private void debugTree(AbstractTreeBuilder aBuilder) {
        TreeUtil.traverseDepth((TreeNode)aBuilder.getTree().getModel().getRoot(), new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                System.out.println("Node: " + node);
                return true;
            }
        });
    }

    private boolean hasSingleSelection() {
        return !this.isSelectionEmpty() && this.getSelectionPaths().length == 1;
    }

    public DefaultTreeModel getBuilderModel() {
        return (DefaultTreeModel)this.getModel();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return super.getPreferredSize();
    }

    public SimpleNodeRenderer getRenderer() {
        return (SimpleNodeRenderer)this.getCellRenderer();
    }

    public String toString() {
        return this.getClass().getName() + '#' + System.identityHashCode(this);
    }

    public final void setMinSizeInRows(int rows) {
        this.myMinHeightInRows = rows;
    }

    public Dimension getMinimumSize() {
        Dimension superSize = super.getMinimumSize();
        if (this.myMinHeightInRows == -1) {
            return superSize;
        }
        int rowCount = this.getRowCount();
        if (rowCount == 0) {
            return superSize;
        }
        double rowHeight = this.getRowBounds(0).getHeight();
        return new Dimension(superSize.width, (int)(rowHeight * (double)this.myMinHeightInRows));
    }

    public final int getToggleClickCount() {
        SimpleNode node = this.getSelectedNode();
        if (node != null && !node.expandOnDoubleClick()) {
            return -1;
        }
        return super.getToggleClickCount();
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.invokePopup(e);
            } else if (SimpleTree.isDoubleClick(e)) {
                SimpleTree.this.handleDoubleClickOrEnter(SimpleTree.this.getClosestPathForLocation(e.getX(), e.getY()), e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.invokePopup(e);
        }

        public void mouseClicked(MouseEvent e) {
            this.invokePopup(e);
        }

        private void invokePopup(MouseEvent e) {
            if (e.isPopupTrigger() && this.insideTreeItemsArea(e)) {
                this.selectPathUnderCursorIfNeeded(e);
                if (SimpleTree.this.myPopupGroup != null) {
                    SimpleTree.this.invokeContextMenu(e);
                }
            }
        }

        private void selectPathUnderCursorIfNeeded(MouseEvent e) {
            TreePath pathForLocation = SimpleTree.this.getClosestPathForLocation(e.getX(), e.getY());
            if (!SimpleTree.this.isSelected(pathForLocation)) {
                SimpleTree.this.setSelectionPath(pathForLocation);
            }
        }

        private boolean insideTreeItemsArea(MouseEvent e) {
            Rectangle rowBounds = SimpleTree.this.getRowBounds(SimpleTree.this.getRowCount() - 1);
            if (rowBounds == null) {
                return false;
            }
            double lastItemBottomLine = rowBounds.getMaxY();
            return (double)e.getY() <= lastItemBottomLine;
        }
    }
}

