/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public class SimpleNodeRenderer
extends NodeRenderer {
    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String text;
        this.mySelected = selected;
        this.myFocused = hasFocus;
        if (selected) {
            this.setPaintFocusBorder(true);
            if (hasFocus) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
            } else {
                this.setBackground(tree.getBackground());
            }
        } else {
            this.setBackground(tree.getBackground());
        }
        Color color = null;
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            if (userObject instanceof NodeDescriptor) {
                NodeDescriptor descriptor = (NodeDescriptor)userObject;
                if (expanded) {
                    this.setIcon(descriptor.getOpenIcon());
                } else {
                    this.setIcon(descriptor.getClosedIcon());
                }
                color = descriptor.getColor();
            }
            if (userObject instanceof SimpleNode) {
                this.renderNodeText((SimpleNode)userObject, this);
                return;
            }
        }
        if ((text = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus)) == null) {
            text = "";
        }
        this.append(text, new SimpleTextAttributes(0, color));
    }

    public void renderNodeText(SimpleNode simpleNode, SimpleColoredComponent component) {
        if (simpleNode.getFont() != null) {
            component.setFont(simpleNode.getFont());
        } else {
            component.setFont(UIManager.getFont("Label.font"));
        }
        if (component.getFont() == null) {
            component.setFont(new JLabel().getFont());
        }
        SimpleNode.ColoredFragment[] fragments = simpleNode.getColoredText();
        for (int i = 0; i < fragments.length; ++i) {
            SimpleNode.ColoredFragment each = fragments[i];
            component.append(each.getText(), each.getAttributes());
            this.setToolTipText(each.getToolTip());
        }
    }

    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/treeStructure/SimpleNodeRenderer.append must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/treeStructure/SimpleNodeRenderer.append must not be null");
        }
        super.append(fragment, attributes, isMainText);
        this.setName(this.getName() + fragment);
    }

    public void clear() {
        super.clear();
        this.setName("");
    }
}

