/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNodeVisitor;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleNode
extends NodeDescriptor
implements ComparableObject {
    protected static final SimpleNode[] NO_CHILDREN = new SimpleNode[0];
    protected final List<ColoredFragment> myColoredText = new CopyOnWriteArrayList<ColoredFragment>();
    private final int myWeight = 10;
    private Font myFont;

    protected SimpleNode(Project project) {
        this(project, null);
    }

    protected SimpleNode(Project project, NodeDescriptor parentDescriptor) {
        super(project, parentDescriptor);
        this.myName = "";
    }

    protected SimpleNode(SimpleNode parent) {
        this(parent == null ? null : parent.myProject, parent);
    }

    protected SimpleNode() {
        super(null, null);
    }

    public String toString() {
        return this.getName();
    }

    public int getWeight() {
        return 10;
    }

    protected SimpleTextAttributes getErrorAttributes() {
        return new SimpleTextAttributes(8, this.getColor(), Color.red);
    }

    protected SimpleTextAttributes getPlainAttributes() {
        return new SimpleTextAttributes(0, this.getColor());
    }

    private FileStatus getFileStatus() {
        return FileStatus.NOT_CHANGED;
    }

    @Nullable
    protected Object updateElement() {
        return this.getElement();
    }

    public final boolean update() {
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                Object newElement = SimpleNode.this.updateElement();
                boolean changed = false;
                if (SimpleNode.this.getElement() != newElement) {
                    changed = true;
                }
                if (newElement == null) {
                    return changed;
                }
                Color oldColor = SimpleNode.this.myColor;
                String oldName = SimpleNode.this.myName;
                Icon oldOpenIcon = SimpleNode.this.myOpenIcon;
                Icon oldClosedIcon = SimpleNode.this.myClosedIcon;
                ArrayList<ColoredFragment> oldFragments = new ArrayList<ColoredFragment>(SimpleNode.this.myColoredText);
                SimpleNode.this.myColor = Color.black;
                assert (SimpleNode.this.getFileStatus() != null) : this.getClass().getName() + ' ' + this.toString();
                Color fileStatusColor = SimpleNode.this.getFileStatus().getColor();
                if (fileStatusColor != null) {
                    SimpleNode.this.myColor = fileStatusColor;
                }
                SimpleNode.this.doUpdate();
                SimpleNode.this.myName = SimpleNode.this.getName();
                return changed || !Comparing.equal(new Object[]{SimpleNode.this.myOpenIcon, SimpleNode.this.myClosedIcon, SimpleNode.this.myName, oldFragments, SimpleNode.this.myColor}, new Object[]{oldOpenIcon, oldClosedIcon, oldName, oldFragments, oldColor});
            }
        });
    }

    public final String getName() {
        StringBuilder result = new StringBuilder("");
        for (ColoredFragment each : this.myColoredText) {
            result.append(each.getText());
        }
        return result.toString();
    }

    public final void setNodeText(String text, String tooltip, boolean hasError) {
        this.clearColoredText();
        SimpleTextAttributes attributes = hasError ? this.getErrorAttributes() : this.getPlainAttributes();
        this.myColoredText.add(new ColoredFragment(text, tooltip, attributes));
    }

    public final void setPlainText(String aText) {
        this.clearColoredText();
        this.addPlainText(aText);
    }

    public final void addPlainText(String aText) {
        this.myColoredText.add(new ColoredFragment(aText, this.getPlainAttributes()));
    }

    public final void addErrorText(String aText, String errorTooltipText) {
        this.myColoredText.add(new ColoredFragment(aText, errorTooltipText, this.getErrorAttributes()));
    }

    public final void clearColoredText() {
        this.myColoredText.clear();
    }

    public final void addColoredFragment(String aText, SimpleTextAttributes aAttributes) {
        this.addColoredFragment(aText, null, aAttributes);
    }

    public final void addColoredFragment(String aText, String toolTip, SimpleTextAttributes aAttributes) {
        this.myColoredText.add(new ColoredFragment(aText, toolTip, aAttributes));
    }

    public final void addColoredFragment(ColoredFragment fragment) {
        this.myColoredText.add(new ColoredFragment(fragment.getText(), fragment.getAttributes()));
    }

    protected void doUpdate() {
    }

    public Object getElement() {
        return this;
    }

    public final SimpleNode getParent() {
        return (SimpleNode)this.getParentDescriptor();
    }

    public abstract SimpleNode[] getChildren();

    public void accept(SimpleNodeVisitor visitor) {
        visitor.accept(this);
    }

    public void handleSelection(SimpleTree tree) {
    }

    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
    }

    public boolean isAlwaysShowPlus() {
        return false;
    }

    public boolean isAutoExpandNode() {
        return false;
    }

    public boolean shouldHaveSeparator() {
        return false;
    }

    public void setUniformIcon(Icon aIcon) {
        this.setIcons(aIcon, aIcon);
    }

    public final void setIcons(Icon aClosed, Icon aOpen) {
        this.myOpenIcon = aOpen;
        this.myClosedIcon = aClosed;
    }

    public final ColoredFragment[] getColoredText() {
        return this.myColoredText.toArray(new ColoredFragment[this.myColoredText.size()]);
    }

    public Object[] getEqualityObjects() {
        return NONE;
    }

    public boolean isAncestorOrSelf(SimpleNode selectedNode) {
        for (SimpleNode node = selectedNode; node != null; node = node.getParent()) {
            if (!this.equals(node)) continue;
            return true;
        }
        return false;
    }

    public Font getFont() {
        return this.myFont;
    }

    public void setFont(Font font) {
        this.myFont = font;
    }

    public final boolean equals(Object o) {
        return ComparableObjectCheck.equals(this, o);
    }

    public final int hashCode() {
        return ComparableObjectCheck.hashCode(this, super.hashCode());
    }

    public static class ColoredFragment {
        private final String myText;
        private final String myToolTip;
        private final SimpleTextAttributes myAttributes;

        public ColoredFragment(String aText, SimpleTextAttributes aAttributes) {
            this(aText, null, aAttributes);
        }

        public ColoredFragment(String aText, String toolTip, SimpleTextAttributes aAttributes) {
            this.myText = aText == null ? "" : aText;
            this.myAttributes = aAttributes;
            this.myToolTip = toolTip;
        }

        public String getToolTip() {
            return this.myToolTip;
        }

        public String getText() {
            return this.myText;
        }

        public SimpleTextAttributes getAttributes() {
            return this.myAttributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColoredFragment that = (ColoredFragment)o;
            if (this.myAttributes != null ? !this.myAttributes.equals(that.myAttributes) : that.myAttributes != null) {
                return false;
            }
            if (this.myText != null ? !this.myText.equals(that.myText) : that.myText != null) {
                return false;
            }
            return !(this.myToolTip != null ? !this.myToolTip.equals(that.myToolTip) : that.myToolTip != null);
        }

        public int hashCode() {
            int result = this.myText != null ? this.myText.hashCode() : 0;
            result = 31 * result + (this.myToolTip != null ? this.myToolTip.hashCode() : 0);
            result = 31 * result + (this.myAttributes != null ? this.myAttributes.hashCode() : 0);
            return result;
        }
    }
}

