/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.util.ArrayUtil;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyTreeBuilder
extends AbstractTreeBuilder {
    private boolean myWaiting;
    private boolean myUpdating;
    private final AbstractTreeStructure myDelegateStructure;

    public LazyTreeBuilder(JTree tree, DefaultTreeModel treeModel, final AbstractTreeStructure structure, Comparator<NodeDescriptor> comparator) {
        super(tree, treeModel, null, comparator);
        this.myDelegateStructure = structure;
        this.myTreeStructure = new AbstractTreeStructure(){

            public Object getRootElement() {
                return structure.getRootElement();
            }

            public Object[] getChildElements(Object element) {
                if (LazyTreeBuilder.this.isWaiting()) {
                    return ArrayUtil.EMPTY_OBJECT_ARRAY;
                }
                return structure.getChildElements(element);
            }

            public Object getParentElement(Object element) {
                return structure.getParentElement(element);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
                NodeDescriptor nodeDescriptor = structure.createDescriptor(element, parentDescriptor);
                if (nodeDescriptor == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/ui/treeStructure/LazyTreeBuilder$1.createDescriptor must not return null");
                }
                return nodeDescriptor;
            }

            public void commit() {
                structure.commit();
            }

            public boolean isToBuildChildrenInBackground(Object element) {
                return LazyTreeBuilder.this.isWaiting();
            }

            public boolean hasSomethingToCommit() {
                return structure.hasSomethingToCommit();
            }
        };
    }

    public final AbstractTreeStructure getDelegateStructure() {
        return this.myDelegateStructure;
    }

    @Override
    protected AbstractTreeUpdater createUpdater() {
        return new AbstractTreeUpdater(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void performUpdate() {
                LazyTreeBuilder.this.setWaiting(false);
                try {
                    LazyTreeBuilder.this.setUpdating(true);
                    super.performUpdate();
                }
                finally {
                    LazyTreeBuilder.this.setUpdating(false);
                }
            }
        };
    }

    @Override
    protected void expandNodeChildren(DefaultMutableTreeNode node) {
        if (this.isWaiting()) {
            this.myUpdater.addSubtreeToUpdate(node);
            this.updateSubtree(node);
        } else {
            super.expandNodeChildren(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWaiting() {
        AbstractTreeUpdater abstractTreeUpdater = this.myUpdater;
        synchronized (abstractTreeUpdater) {
            return this.myWaiting;
        }
    }

    @Override
    protected void updateNode(DefaultMutableTreeNode node) {
        if (this.isWaiting()) {
            return;
        }
        super.updateNode(node);
    }

    public final void queueUpdate() {
        this.queueUpdate(this.myRootNode);
    }

    public final void queueUpdate(DefaultMutableTreeNode node) {
        this.setWaiting(true);
        this.myUpdater.addSubtreeToUpdate(node);
    }

    public final boolean queueUpdateByElement(Object element) {
        this.setWaiting(true);
        return this.myUpdater.addSubtreeToUpdateByElement(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWaiting(boolean b) {
        AbstractTreeUpdater abstractTreeUpdater = this.myUpdater;
        synchronized (abstractTreeUpdater) {
            if (this.myUpdating) {
                return;
            }
            this.myWaiting = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpdating(boolean updating) {
        AbstractTreeUpdater abstractTreeUpdater = this.myUpdater;
        synchronized (abstractTreeUpdater) {
            this.myUpdating = updating;
        }
    }
}

