/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.treeStructure.LazyTreeBuilder;
import com.intellij.ui.treeStructure.PatchedDefaultMutableTreeNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import java.awt.EventQueue;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazySimpleTreeBuilder
extends LazyTreeBuilder {
    public LazySimpleTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure structure, Comparator<NodeDescriptor> comparator) {
        super(tree, treeModel, structure, comparator);
    }

    @Override
    public boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return ((SimpleNode)nodeDescriptor).isAlwaysShowPlus();
    }

    @Override
    public boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return ((SimpleNode)nodeDescriptor).isAutoExpandNode();
    }

    @Override
    protected String getLoadingNodeText() {
        return "   ";
    }

    @Override
    public final void updateFromRoot() {
        this.updateFromRoot(false);
    }

    public void updateFromRoot(boolean rebuild) {
        if (rebuild) {
            this.cleanUpStructureCaches();
        }
        if (EventQueue.isDispatchThread()) {
            LazySimpleTreeBuilder.super.updateFromRoot();
        } else {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                public void run() {
                    LazySimpleTreeBuilder.super.updateFromRoot();
                }
            });
        }
    }

    @Override
    protected final DefaultMutableTreeNode createChildNode(NodeDescriptor childDescr) {
        return new PatchedDefaultMutableTreeNode(childDescr);
    }

    private void cleanUpStructureCaches() {
        if (!(this.myTreeStructure instanceof SimpleTreeStructure)) {
            return;
        }
        ((SimpleTreeStructure)this.myTreeStructure).clearCaches();
    }

    public LazySimpleTreeBuilder initRoot() {
        this.initRootNode();
        return this;
    }
}

