/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;

public abstract class InplaceEditor
extends AbstractCellEditor
implements TreeCellEditor,
FocusListener {
    protected JTree myTree;
    protected JTextField myTextField;
    protected JPanel myComponent;
    protected JLabel myIconLabel = new JLabel();
    protected int myIconTextGap;

    public InplaceEditor() {
        this.myTextField = new JTextField(){

            public Dimension getPreferredSize() {
                Dimension prefSize = super.getPreferredSize();
                Dimension minSize = new Dimension(this.getColumnWidth() * 3, prefSize.height - 1);
                prefSize.width += 15;
                return InplaceEditor.this.computeNotSmallerDimension(prefSize, minSize);
            }
        };
        this.myTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 9: 
                    case 10: {
                        if (!InplaceEditor.this.stopCellEditing()) break;
                        InplaceEditor.this.myTree.stopEditing();
                        InplaceEditor.this.myTree.requestFocusInWindow();
                        break;
                    }
                    case 27: {
                        if (InplaceEditor.this.myTree instanceof SimpleTree) {
                            ((SimpleTree)InplaceEditor.this.myTree).setEscapePressed();
                        }
                        InplaceEditor.this.myTree.cancelEditing();
                        InplaceEditor.this.myTree.requestFocusInWindow();
                    }
                }
            }
        });
        this.myComponent = new NonOpaquePanel(){

            public void invalidate() {
                super.invalidate();
                Dimension size = this.getSize();
                size.width = InplaceEditor.this.myTextField.getPreferredSize().width + InplaceEditor.this.myIconLabel.getPreferredSize().width + InplaceEditor.this.myIconTextGap;
                InplaceEditor.this.myComponent.setSize(size);
                InplaceEditor.this.myTree.revalidate();
            }
        };
        this.myComponent.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                InplaceEditor.this.myTextField.requestFocus();
                InplaceEditor.this.myTextField.selectAll();
            }

            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != InplaceEditor.this.myTextField) {
                    InplaceEditor.this.myTree.stopEditing();
                }
            }
        });
    }

    private Dimension computeNotSmallerDimension(Dimension prefSize, Dimension minSize) {
        int resultWidth = prefSize.width < minSize.width ? minSize.width : prefSize.width;
        int resultHeight = prefSize.height < minSize.height ? minSize.height : prefSize.height;
        return new Dimension(resultWidth, resultHeight);
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.myTree = tree;
        NodeRenderer renderer = (NodeRenderer)tree.getCellRenderer().getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, false);
        this.rebuildUI(renderer);
        this.myIconLabel.setIcon(renderer.getIcon());
        this.myTextField.setText(this.getText(((DefaultMutableTreeNode)value).getUserObject()));
        this.myTextField.addFocusListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InplaceEditor.this.myTextField.selectAll();
            }
        });
        return this.myComponent;
    }

    protected abstract String getText(Object var1);

    public abstract boolean setTextIfValid(String var1);

    public JTextField getTextField() {
        return this.myTextField;
    }

    public boolean stopCellEditing() {
        boolean stopped = this.setTextIfValid(this.myTextField.getText());
        if (stopped) {
            this.myTextField.removeFocusListener(this);
            return super.stopCellEditing();
        }
        return stopped;
    }

    public void cancelCellEditing() {
        this.myTextField.removeFocusListener(this);
        super.cancelCellEditing();
    }

    private void rebuildUI(NodeRenderer aRenderer) {
        this.myComponent.removeAll();
        this.myIconTextGap = aRenderer.getIconTextGap() - this.myTextField.getBorder().getBorderInsets((Component)this.myTextField).left + 1;
        this.myComponent.setLayout(new BorderLayout(this.myIconTextGap, 0));
        this.myComponent.add((Component)this.myTextField, "Center");
        this.myComponent.add((Component)this.myIconLabel, "West");
        Insets padding = aRenderer.getIpad();
        this.myComponent.setBorder(BorderFactory.createEmptyBorder(padding.top, padding.left, padding.bottom, padding.right));
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.myTree.isEditing() && !e.isTemporary()) {
            if (this.stopCellEditing()) {
                this.myTree.stopEditing();
            } else {
                this.myTree.cancelEditing();
            }
        }
    }
}

