/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.treeStructure.SimpleNode;

public class FolderNode
extends SimpleNode {
    private final String myFQName;
    private final String myName;

    public FolderNode(FolderNode aParent, String name) {
        super(aParent);
        this.myName = name;
        String parentFqn = aParent.myFQName;
        this.myFQName = "".equals(parentFqn) ? this.myName : parentFqn + '.' + this.myName;
        this.init();
    }

    public FolderNode(Project aProject) {
        this(aProject, null);
    }

    public FolderNode(Project aProject, NodeDescriptor parent) {
        super(aProject, parent);
        this.myName = "";
        this.myFQName = "";
        this.init();
    }

    private void init() {
        this.setPlainText(this.myName);
        this.setIcons(IconLoader.getIcon("/nodes/folder.png"), IconLoader.getIcon("/nodes/folderOpen.png"));
    }

    public final SimpleNode[] getChildren() {
        throw new UnsupportedOperationException("Not Implemented in: " + this.getClass().getName());
    }

    public Object[] getEqualityObjects() {
        return new Object[]{this.myFQName, this.getClass()};
    }

    public String getFullyQualifiedName() {
        return this.myFQName;
    }
}

