/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.table;

import com.intellij.ui.TableUtil;
import com.intellij.ui.table.BaseTableView;
import com.intellij.ui.table.ItemsProvider;
import com.intellij.ui.table.SelectionProvider;
import com.intellij.ui.table.TableHeaderRenderer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.TableViewModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableView<Item>
extends BaseTableView
implements ItemsProvider,
SelectionProvider {
    public TableView() {
        this(new ListTableModel(ColumnInfo.EMPTY_ARRAY));
    }

    public TableView(ListTableModel<Item> model) {
        super(model);
        this.setModel(model);
    }

    public void setModel(ListTableModel<Item> model) {
        super.setModel(model);
        this.getTableHeader().setDefaultRenderer(new TableHeaderRenderer(model));
        this.setSizes();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        ColumnInfo columnInfo = this.getListTableModel().getColumnInfos()[this.convertColumnIndexToModel(column)];
        TableCellRenderer renderer = columnInfo.getRenderer(this.getListTableModel().getItems().get(row));
        if (renderer == null) {
            return super.getCellRenderer(row, column);
        }
        return renderer;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.isEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
        super.tableChanged(e);
    }

    private void setSelection(Collection<Item> selection) {
        this.clearSelection();
        Iterator<Item> iterator = selection.iterator();
        while (iterator.hasNext()) {
            this.addSelection(iterator.next());
        }
    }

    private void setSizes() {
        ColumnInfo[] columns = this.getListTableModel().getColumnInfos();
        for (int i = 0; i < columns.length; ++i) {
            int width;
            ColumnInfo columnInfo = columns[i];
            TableColumn column = this.getColumnModel().getColumn(i);
            if (columnInfo.getWidth(this) > 0) {
                int wight = columnInfo.getWidth(this);
                column.setMaxWidth(wight);
                column.setMinWidth(wight);
                continue;
            }
            if (columnInfo.getMaxStringValue() != null) {
                String maxStringValue = columnInfo.getMaxStringValue();
                width = this.getFontMetrics(this.getFont()).stringWidth(maxStringValue) + columnInfo.getAdditionalWidth();
                column.setPreferredWidth(width);
                column.setMaxWidth(width);
                continue;
            }
            String preferredValue = columnInfo.getPreferredStringValue();
            if (preferredValue == null) continue;
            width = this.getFontMetrics(this.getFont()).stringWidth(preferredValue) + columnInfo.getAdditionalWidth();
            column.setPreferredWidth(width);
        }
    }

    @Override
    public Collection<Item> getSelection() {
        ArrayList<Item> result = new ArrayList<Item>();
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows == null) {
            return result;
        }
        for (int selectedRow : selectedRows) {
            result.add(this.getItems().get(selectedRow));
        }
        return result;
    }

    @Nullable
    public Item getSelectedObject() {
        int row = this.getSelectedRow();
        List<Item> list = this.getItems();
        return row >= 0 && row < list.size() ? (Item)list.get(row) : null;
    }

    @Override
    public void addSelection(Object item) {
        List<Item> items = this.getItems();
        if (!items.contains(item)) {
            return;
        }
        int index = items.indexOf(item);
        this.getSelectionModel().addSelectionInterval(index, index);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        ColumnInfo columnInfo = this.getListTableModel().getColumnInfos()[this.convertColumnIndexToModel(column)];
        TableCellEditor editor = columnInfo.getEditor(this.getListTableModel().getItems().get(row));
        if (editor == null) {
            return super.getCellEditor(row, column);
        }
        return editor;
    }

    @Override
    public List<Item> getItems() {
        return ((ListTableModel)this.getModel()).getItems();
    }

    @Override
    protected void onHeaderClicked(int column) {
        ListTableModel model = this.getListTableModel();
        Collection<Item> selection = this.getSelection();
        model.sortByColumn(column);
        this.setSelection(selection);
    }

    public void setMinRowHeight(int i) {
        this.setRowHeight(Math.max(i, this.getRowHeight()));
    }

    public JTable getComponent() {
        return this;
    }

    public TableViewModel getTableViewModel() {
        return this.getListTableModel();
    }

    public void stopEditing() {
        TableUtil.stopEditing(this);
    }
}

