/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.table;

import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.SortableColumnModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class TableHeaderRenderer
extends JPanel
implements TableCellRenderer {
    private final SortableColumnModel myModel;
    protected final JLabel myLabel = new JLabel("", 0);
    private final JPanel myIconPanel = new JPanel(new BorderLayout());
    private final JPanel mySpace = new JPanel(new BorderLayout());
    private final JLabel myIconLabel = new JLabel();
    private final Border myBorder;

    public TableHeaderRenderer(SortableColumnModel model) {
        this(model, UIUtil.getTableHeaderCellBorder());
    }

    public TableHeaderRenderer(SortableColumnModel model, Border border) {
        super(new BorderLayout(0, 0));
        this.myModel = model;
        this.add((Component)this.myLabel, "Center");
        this.add((Component)this.myIconPanel, "East");
        this.mySpace.setMaximumSize(new Dimension(10, 0));
        this.mySpace.setOpaque(false);
        this.myIconPanel.add((Component)this.myIconLabel, "Center");
        this.myIconPanel.add((Component)this.mySpace, "East");
        this.myIconPanel.setOpaque(false);
        this.myBorder = border;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Icon icon = null;
        int logicalIndex = table.convertColumnIndexToModel(column);
        if (logicalIndex >= this.myModel.getColumnInfos().length) {
            this.setText("");
            return this;
        }
        ColumnInfo columnInfo = this.myModel.getColumnInfos()[logicalIndex];
        String labelString = columnInfo.getName();
        if (this.myModel.isSortable() && columnInfo.isSortable() && this.myModel.getSortedColumnIndex() == logicalIndex) {
            labelString = "<html><b>" + labelString + "</b></html>";
            if (this.myModel.getSortingType() == 1) {
                icon = IconLoader.getIcon("/actions/sortAsc.png");
            }
            if (this.myModel.getSortingType() == 2) {
                icon = IconLoader.getIcon("/actions/sortDesc.png");
            }
        }
        this.setText(labelString);
        this.setIcon(icon);
        boolean hasError = columnInfo.hasError();
        JTableHeader header = table.getTableHeader();
        Color foreground = hasError ? Color.RED : header.getForeground();
        this.setForeground(foreground);
        this.myLabel.setForeground(foreground);
        this.setBackground(header.getBackground());
        this.myLabel.setFont(header.getFont());
        this.setBorder(this.myBorder);
        return this;
    }

    private void setText(String labelString) {
        this.myLabel.setText(labelString);
    }

    private void setIcon(Icon icon) {
        this.myIconLabel.setIcon(icon);
        if (icon == null) {
            this.myIconLabel.setMaximumSize(new Dimension(0, 0));
            this.mySpace.setMaximumSize(new Dimension(0, 0));
        } else {
            this.myIconLabel.setMaximumSize(this.myIconLabel.getPreferredSize());
            this.mySpace.setMaximumSize(new Dimension(10, 0));
        }
    }
}

