/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.navigation;

import com.intellij.ui.navigation.Place;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class History {
    private List<Place> myHistory;
    private int myCurrentPos;
    private Place.Navigator myRoot;
    private boolean myNavigatedNow;

    public History(@NotNull Place.Navigator root) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/navigation/History.<init> must not be null");
        }
        this.myHistory = new ArrayList<Place>();
        this.myRoot = root;
    }

    public void pushQueryPlace() {
        if (this.isNavigatingNow()) {
            return;
        }
        Place place = this.query();
        if (place != null) {
            this.pushPlace(this.query());
        }
    }

    public void pushPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/navigation/History.pushPlace must not be null");
        }
        while (this.myCurrentPos > 0 && this.myHistory.size() > 0 && this.myCurrentPos < this.myHistory.size() - 1) {
            this.myHistory.remove(this.myHistory.size() - 1);
        }
        if (this.myHistory.size() > 0) {
            Place prev = this.myHistory.get(this.myHistory.size() - 1);
            if (prev.equals(place)) {
                return;
            }
            if (prev.isMoreGeneralFor(place)) {
                this.myHistory.remove(prev);
            }
        }
        this.addPlace(place);
    }

    private void addPlace(Place place) {
        this.myHistory.add(place);
        this.myCurrentPos = this.myHistory.size() - 1;
    }

    public void pushPlaceForElement(String name, Object value) {
        if (!this.canNavigateFor(name)) {
            return;
        }
        Place checkPlace = this.getCheckPlace(name);
        if (checkPlace == null) {
            return;
        }
        this.pushPlace(checkPlace.cloneForElement(name, value));
    }

    public Place getPlaceForElement(String name, String value) {
        Place checkPlace = this.getCheckPlace(name);
        if (checkPlace == null) {
            return new Place();
        }
        return checkPlace.cloneForElement(name, value);
    }

    public void navigateTo(Place place) {
        this.myRoot.navigateTo(place, false);
    }

    public void back() {
        assert (this.canGoBack());
        this.goThere(this.myCurrentPos - 1);
    }

    private void goThere(final int nextPos) {
        this.myNavigatedNow = true;
        Place next = this.myHistory.get(nextPos);
        try {
            this.myRoot.navigateTo(next, false).doWhenDone(new Runnable(){

                public void run() {
                    History.this.myCurrentPos = nextPos;
                    History.this.myNavigatedNow = false;
                }
            });
        }
        catch (Throwable e) {
            this.myNavigatedNow = false;
            throw new RuntimeException(e);
        }
    }

    public boolean isNavigatingNow() {
        return this.myNavigatedNow;
    }

    public boolean canGoBack() {
        return this.myHistory.size() > 1 && this.myCurrentPos > 0;
    }

    public void forward() {
        assert (this.canGoForward());
        this.goThere(this.myCurrentPos + 1);
    }

    public boolean canGoForward() {
        return this.myHistory.size() > 1 && this.myCurrentPos < this.myHistory.size() - 1;
    }

    public void clear() {
        this.myHistory.clear();
        this.myCurrentPos = -1;
    }

    public Place query() {
        Place result = new Place();
        this.myRoot.queryPlace(result);
        return result;
    }

    private Place getCurrent() {
        if (this.myCurrentPos >= 0 && this.myCurrentPos < this.myHistory.size()) {
            return this.myHistory.get(this.myCurrentPos);
        }
        return null;
    }

    private boolean canNavigateFor(String pathElement) {
        if (this.isNavigatingNow()) {
            return false;
        }
        Place checkPlace = this.getCheckPlace(pathElement);
        return checkPlace != null && checkPlace.getPath(pathElement) != null;
    }

    @Nullable
    private Place getCheckPlace(String pathElement) {
        Place checkPlace = this.getCurrent();
        if (checkPlace == null || checkPlace.getPath(pathElement) == null) {
            checkPlace = this.query();
        }
        return checkPlace != null && checkPlace.getPath(pathElement) != null ? checkPlace : null;
    }
}

