/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dualView;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.fileView.DualViewColumnInfo;
import com.intellij.peer.PeerFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.UIBundle;
import com.intellij.ui.UIHelper;
import com.intellij.ui.dualView.CellWrapper;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.table.BaseTableView;
import com.intellij.ui.table.SelectionProvider;
import com.intellij.ui.table.TableView;
import com.intellij.util.config.Storage;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.Table;
import com.intellij.util.ui.Tree;
import com.intellij.util.ui.treetable.ListTreeTableModelOnColumns;
import com.intellij.util.ui.treetable.TreeTableModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;

public class DualView
extends JPanel {
    private final CardLayout myCardLayout;
    private TreeTableView myTreeView;
    private JTable myCurrentView = null;
    private TableView myFlatView;
    @NonNls
    private static final String TREE = "TREE";
    @NonNls
    private static final String FLAT = "FLAT";
    private TreeCellRenderer myTreeCellRenderer;
    private boolean myRootVisible;
    private boolean myTableRefreshingIsLocked = false;
    private CellWrapper myCellWrapper;
    private final Storage.PropertiesComponentStorage myFlatStorage;
    private final Storage.PropertiesComponentStorage myTreeStorage;
    private final PropertyChangeListener myPropertyChangeListener;

    public DualView(Object root, DualViewColumnInfo[] columns, @NonNls String columnServiceKey, Project project) {
        super(new CardLayout());
        this.myTreeStorage = new Storage.PropertiesComponentStorage(columnServiceKey + "_tree", PropertiesComponent.getInstance(project));
        this.myFlatStorage = new Storage.PropertiesComponentStorage(columnServiceKey + "_flat", PropertiesComponent.getInstance(project));
        this.myCardLayout = (CardLayout)this.getLayout();
        this.add(this.createTreeComponent(columns, (TreeNode)root), TREE);
        this.add(this.createFlatComponent(columns), FLAT);
        this.myTreeView.getTreeViewModel().addTreeModelListener(new TreeModelListener(){

            public void treeNodesInserted(TreeModelEvent e) {
                DualView.this.refreshFlatModel();
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                DualView.this.refreshFlatModel();
            }

            public void treeStructureChanged(TreeModelEvent e) {
                DualView.this.refreshFlatModel();
            }

            public void treeNodesChanged(TreeModelEvent e) {
                DualView.this.refreshFlatModel();
            }
        });
        this.setRootVisible(true);
        this.switchToTheFlatMode();
        this.restoreState();
        this.myPropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DualView.this.saveState();
            }
        };
        this.addWidthListenersTo(this.myTreeView);
        this.addWidthListenersTo(this.myFlatView);
    }

    private void addWidthListenersTo(Table treeView) {
        TableColumnModel columnModel = treeView.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            columnModel.getColumn(i).addPropertyChangeListener(this.myPropertyChangeListener);
        }
    }

    public void restoreState() {
        BaseTableView.restore(this.myFlatStorage, this.myFlatView);
        BaseTableView.restore(this.myTreeStorage, this.myTreeView);
    }

    public void lockTableRefreshing() {
        this.myTableRefreshingIsLocked = true;
    }

    public void unlockTableRefreshingAndRefresh() {
        this.myTableRefreshingIsLocked = false;
        this.refreshFlatModel();
    }

    private void refreshFlatModel() {
        if (this.myTableRefreshingIsLocked) {
            return;
        }
        ((ListTableModel)this.myFlatView.getModel()).setItems(this.myTreeView.getFlattenItems());
    }

    private ColumnInfo[] createTreeColumns(DualViewColumnInfo[] columns) {
        ArrayList<ColumnInfo> result = new ArrayList<ColumnInfo>();
        final DualViewColumnInfo firstColumn = columns[0];
        ColumnInfo firstTreeColumn = new ColumnInfo(firstColumn.getName()){

            public Object valueOf(Object object) {
                return firstColumn.valueOf(object);
            }

            public Class getColumnClass() {
                return TreeTableModel.class;
            }

            public boolean isCellEditable(Object o) {
                return true;
            }
        };
        result.add(firstTreeColumn);
        for (int i = 1; i < columns.length; ++i) {
            DualViewColumnInfo column = columns[i];
            if (!column.shouldBeShownIsTheTree()) continue;
            result.add(column);
        }
        return result.toArray(new ColumnInfo[result.size()]);
    }

    public void switchToTheFlatMode() {
        if (this.myFlatView == this.myCurrentView) {
            return;
        }
        this.changeViewTo(this.myFlatView);
        this.copySelection(this.myTreeView, this.myFlatView);
        this.myCardLayout.show(this, FLAT);
    }

    private void changeViewTo(JTable view) {
        this.myCurrentView = view;
    }

    private void copySelection(SelectionProvider from, SelectionProvider to) {
        to.clearSelection();
        Collection selection = from.getSelection();
        Iterator each = selection.iterator();
        while (each.hasNext()) {
            to.addSelection(each.next());
        }
    }

    public void switchToTheTreeMode() {
        if (this.myTreeView == this.myCurrentView) {
            return;
        }
        this.changeViewTo(this.myTreeView);
        this.copySelection(this.myFlatView, this.myTreeView);
        this.myCardLayout.show(this, TREE);
    }

    private Component createTreeComponent(DualViewColumnInfo[] columns, TreeNode root) {
        this.myTreeView = new TreeTableView(new ListTreeTableModelOnColumns(root, this.createTreeColumns(columns))){

            public TableCellRenderer getCellRenderer(int row, int column) {
                return DualView.this.createWrappedRenderer(super.getCellRenderer(row, column));
            }
        };
        this.myTreeView.getTree().getSelectionModel().setSelectionMode(4);
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)ScrollPaneFactory.createScrollPane(this.myTreeView), "Center");
        return result;
    }

    private Component createFlatComponent(DualViewColumnInfo[] columns) {
        ArrayList<DualViewColumnInfo> shownColumns = new ArrayList<DualViewColumnInfo>();
        for (int i = 0; i < columns.length; ++i) {
            DualViewColumnInfo column = columns[i];
            if (!column.shouldBeShownIsTheTable()) continue;
            shownColumns.add(column);
        }
        ListTableModel flatModel = new ListTableModel(shownColumns.toArray(new ColumnInfo[shownColumns.size()]));
        this.myFlatView = new TableView(flatModel){

            public TableCellRenderer getCellRenderer(int row, int column) {
                return DualView.this.createWrappedRenderer(super.getCellRenderer(row, column));
            }
        };
        this.refreshFlatModel();
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)ScrollPaneFactory.createScrollPane(this.myFlatView), "Center");
        return result;
    }

    private TableCellRenderer createWrappedRenderer(TableCellRenderer renderer) {
        if (this.myCellWrapper == null) {
            return renderer;
        }
        return new TableCellRendererWrapper(renderer);
    }

    public void expandAll() {
        this.expandPath(this.myTreeView.getTree(), new TreePath(this.myTreeView.getTree().getModel().getRoot()));
    }

    public void collapseAll() {
        this.collapsePath(this.myTreeView.getTree(), new TreePath(this.myTreeView.getTree().getModel().getRoot()));
    }

    private void expandPath(JTree tree, TreePath path) {
        tree.expandPath(path);
        TreeNode node = (TreeNode)path.getLastPathComponent();
        Enumeration<? extends TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            this.expandPath(tree, path.pathByAddingChild(child));
        }
    }

    private void collapsePath(JTree tree, TreePath path) {
        TreeNode node = (TreeNode)path.getLastPathComponent();
        Enumeration<? extends TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            this.collapsePath(tree, path.pathByAddingChild(child));
        }
        if (path.getLastPathComponent() != tree.getModel().getRoot() || this.myRootVisible) {
            tree.collapsePath(path);
        }
    }

    public List getSelection() {
        ArrayList result = new ArrayList();
        SelectionProvider visibleTable = (SelectionProvider)((Object)this.getVisibleTable());
        Collection selection = visibleTable.getSelection();
        Iterator each = selection.iterator();
        while (each.hasNext()) {
            result.add(each.next());
        }
        return result;
    }

    private JTable getVisibleTable() {
        return this.myCurrentView;
    }

    public void setShowGrid(boolean aBoolean) {
        this.myTreeView.setShowGrid(aBoolean);
    }

    public void setSelectionInterval(int first, int last) {
        this.myTreeView.getSelectionModel().addSelectionInterval(first, last);
        this.myFlatView.getSelectionModel().addSelectionInterval(first, last);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.myTreeView.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.myFlatView.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void changeColumnSet(DualViewColumnInfo[] columns) {
        this.myTreeView.setTableModel(new ListTreeTableModelOnColumns((TreeNode)this.myTreeView.getTreeViewModel().getRoot(), this.createTreeColumns(columns)));
        this.myFlatView.setModel(new ListTableModel((ColumnInfo[])columns));
        if (this.myTreeCellRenderer != null) {
            this.myTreeView.setTreeCellRenderer(this.myTreeCellRenderer);
        }
        this.setRootVisible(this.myRootVisible);
        this.refreshFlatModel();
        this.addWidthListenersTo(this.myTreeView);
        this.addWidthListenersTo(this.myFlatView);
    }

    public Tree getTree() {
        return this.myTreeView.getTree();
    }

    public TreeTableView getTreeView() {
        return this.myTreeView;
    }

    public TableView getFlatView() {
        return this.myFlatView;
    }

    public void setRootVisible(boolean aBoolean) {
        this.myRootVisible = aBoolean;
        this.myTreeView.setRootVisible(this.myRootVisible);
    }

    public void setTreeCellRenderer(TreeCellRenderer cellRenderer) {
        this.myTreeCellRenderer = cellRenderer;
        this.myTreeView.setTreeCellRenderer(cellRenderer);
    }

    public AnAction getExpandAllAction() {
        return new AnAction(UIBundle.message("tree.view.expand.all.action.name", new Object[0]), null, IconLoader.getIcon("/actions/expandall.png")){

            public void update(AnActionEvent e) {
                Presentation presentation = e.getPresentation();
                presentation.setVisible(true);
                presentation.setEnabled(DualView.this.myCurrentView == DualView.this.myTreeView);
            }

            public void actionPerformed(AnActionEvent e) {
                DualView.this.expandAll();
            }
        };
    }

    public AnAction getCollapseAllAction() {
        return new AnAction(UIBundle.message("tree.view.collapse.all.action.name", new Object[0]), null, IconLoader.getIcon("/actions/collapseall.png")){

            public void update(AnActionEvent e) {
                Presentation presentation = e.getPresentation();
                presentation.setVisible(true);
                presentation.setEnabled(DualView.this.myCurrentView == DualView.this.myTreeView);
            }

            public void actionPerformed(AnActionEvent e) {
                DualView.this.collapseAll();
            }
        };
    }

    public void setCellWrapper(CellWrapper wrapper) {
        this.myCellWrapper = wrapper;
    }

    public void installEditSourceOnDoubleClickHandler() {
        UIHelper uiHelper = PeerFactory.getInstance().getUIHelper();
        uiHelper.installEditSourceOnDoubleClick(this.myTreeView);
        uiHelper.installEditSourceOnDoubleClick(this.myFlatView);
    }

    public void installDoubleClickHandler(AnAction action) {
        action.registerCustomShortcutSet(CommonShortcuts.DOUBLE_CLICK_1, this.myFlatView);
        action.registerCustomShortcutSet(CommonShortcuts.DOUBLE_CLICK_1, this.myTreeView);
    }

    public void dispose() {
        this.saveState();
    }

    public void saveState() {
        BaseTableView.store(this.myFlatStorage, this.myFlatView);
        BaseTableView.store(this.myTreeStorage, this.myTreeView);
    }

    public void setRoot(TreeNode node) {
        this.myTreeView.getTreeViewModel().setRoot(node);
    }

    public void rebuild() {
        ((AbstractTableModel)this.myFlatView.getModel()).fireTableDataChanged();
        ((AbstractTableModel)this.myTreeView.getModel()).fireTableDataChanged();
    }

    public class TableCellRendererWrapper
    implements TableCellRenderer {
        private final TableCellRenderer myRenderer;

        public TableCellRendererWrapper(TableCellRenderer renderer) {
            this.myRenderer = renderer;
        }

        public TableCellRenderer getRenderer() {
            return this.myRenderer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component result = this.myRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Object treeNode = null;
            if (DualView.this.myCurrentView == DualView.this.myTreeView) {
                TreePath path = DualView.this.myTreeView.getTree().getPathForRow(row);
                if (path != null) {
                    treeNode = path.getLastPathComponent();
                }
            } else if (DualView.this.myCurrentView == DualView.this.myFlatView) {
                treeNode = DualView.this.myFlatView.getItems().get(row);
            }
            DualView.this.myCellWrapper.wrap(result, table, value, isSelected, hasFocus, row, column, treeNode);
            return result;
        }
    }
}

