/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.classFilter;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.UIBundle;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.ClassFilterEditorAddDialog;
import com.intellij.util.ui.Table;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;

public class ClassFilterEditor
extends JPanel {
    protected JTable myTable = null;
    protected FilterTableModel myTableModel = null;
    private JButton myAddClassButton = new JButton(UIBundle.message("button.add.class", new Object[0]));
    protected JButton myAddPatternButton = new JButton(this.getAddPatternButtonText());
    private JButton myRemoveButton = new JButton(UIBundle.message("button.remove", new Object[0]));
    protected Project myProject;
    private TreeClassChooser.ClassFilter myChooserFilter;

    public ClassFilterEditor(Project project) {
        this(project, null);
    }

    public ClassFilterEditor(Project project, TreeClassChooser.ClassFilter classFilter) {
        super(new GridBagLayout());
        this.myTable = new Table();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myTable);
        this.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 3, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 6), 0, 0));
        this.add((Component)this.myAddClassButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 0, 0, 4), 0, 0));
        this.add((Component)this.myAddPatternButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 0, 0, 4), 0, 0));
        this.add((Component)this.myRemoveButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 18, 2, new Insets(4, 0, 0, 4), 0, 0));
        this.myChooserFilter = classFilter;
        this.myProject = project;
        this.myAddClassButton.setDefaultCapable(false);
        this.myAddPatternButton.setDefaultCapable(false);
        this.myRemoveButton.setDefaultCapable(false);
        this.myTableModel = new FilterTableModel();
        this.myTable.setModel(this.myTableModel);
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        this.myTable.setTableHeader(null);
        this.myTable.setAutoResizeMode(3);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.setPreferredScrollableViewportSize(new Dimension(200, 100));
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        int width = new JCheckBox().getPreferredSize().width;
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setCellRenderer(new EnabledCellRenderer(this.myTable.getDefaultRenderer(Boolean.class)));
        columnModel.getColumn(1).setCellRenderer(new FilterCellRenderer());
        this.myTable.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassFilterEditor.this.myAddClassButton.doClick();
            }
        }, KeyStroke.getKeyStroke(155, 0), 0);
        this.myTable.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassFilterEditor.this.myRemoveButton.doClick();
            }
        }, KeyStroke.getKeyStroke(127, 0), 0);
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ClassFilterEditor.this.myRemoveButton.setEnabled(ClassFilterEditor.this.myTable.getSelectedRow() > -1);
            }
        });
        this.myAddPatternButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassFilterEditor.this.addPatternFilter();
            }
        });
        this.myAddClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassFilterEditor.this.addClassFilter();
            }
        });
        this.myRemoveButton.addActionListener(new RemoveAction());
        this.myRemoveButton.setEnabled(false);
    }

    protected String getAddPatternButtonText() {
        return UIBundle.message("button.add.pattern", new Object[0]);
    }

    public void setFilters(ClassFilter[] filters) {
        this.myTableModel.setFilters(filters);
    }

    public ClassFilter[] getFilters() {
        return this.myTableModel.getFilters();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myAddPatternButton.setEnabled(enabled);
        this.myAddClassButton.setEnabled(enabled);
        this.myRemoveButton.setEnabled(this.myTable.getSelectedRow() > -1 && enabled);
        this.myTable.setRowSelectionAllowed(enabled);
        this.myTableModel.fireTableDataChanged();
    }

    public void stopEditing() {
        TableCellEditor editor = this.myTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected ClassFilter createFilter(String pattern) {
        ClassFilter classFilter = new ClassFilter(pattern);
        if (classFilter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/classFilter/ClassFilterEditor.createFilter must not return null");
        }
        return classFilter;
    }

    protected void addPatternFilter() {
        String pattern;
        ClassFilterEditorAddDialog dialog = new ClassFilterEditorAddDialog(this.myProject);
        dialog.show();
        if (dialog.isOK() && (pattern = dialog.getPattern()) != null) {
            ClassFilter filter = this.createFilter(pattern);
            if (filter != null) {
                this.myTableModel.addRow(filter);
                int row = this.myTableModel.getRowCount() - 1;
                this.myTable.getSelectionModel().setSelectionInterval(row, row);
                this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
            }
            this.myTable.requestFocus();
        }
    }

    protected void addClassFilter() {
        TreeClassChooser chooser = TreeClassChooserFactory.getInstance(this.myProject).createNoInnerClassesScopeChooser(UIBundle.message("class.filter.editor.choose.class.title", new Object[0]), GlobalSearchScope.allScope(this.myProject), this.myChooserFilter, null);
        chooser.showDialog();
        PsiClass selectedClass = chooser.getSelectedClass();
        if (selectedClass != null) {
            ClassFilter filter = this.createFilter(this.getJvmClassName(selectedClass));
            if (filter != null) {
                this.myTableModel.addRow(filter);
                int row = this.myTableModel.getRowCount() - 1;
                this.myTable.getSelectionModel().setSelectionInterval(row, row);
                this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
            }
            this.myTable.requestFocus();
        }
    }

    private String getJvmClassName(PsiClass aClass) {
        PsiClass parentClass = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, true);
        if (parentClass != null) {
            String parentName = this.getJvmClassName(parentClass);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    public void addPattern(String pattern) {
        ClassFilter filter = this.createFilter(pattern);
        if (filter != null) {
            this.myTableModel.addRow(filter);
        }
    }

    private final class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ClassFilterEditor.this.myTable.getRowCount() == 0) {
                return;
            }
            int[] rows = ClassFilterEditor.this.myTable.getSelectedRows();
            ClassFilterEditor.this.stopEditing();
            if (rows.length > 0) {
                int newRow = rows[0] - 1;
                ClassFilter filter = newRow >= 0 && newRow < ClassFilterEditor.this.myTableModel.getRowCount() ? ClassFilterEditor.this.myTableModel.getFilterAt(newRow) : null;
                ClassFilterEditor.this.myTableModel.removeRows(rows);
                int indexToSelect = 0;
                if (filter != null && (indexToSelect = ClassFilterEditor.this.myTableModel.getFilterIndex(filter)) < 0) {
                    indexToSelect = 0;
                }
                if (ClassFilterEditor.this.myTableModel.getRowCount() > 0) {
                    ClassFilterEditor.this.myTable.getSelectionModel().setSelectionInterval(indexToSelect, indexToSelect);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ClassFilterEditor.this.myTable.requestFocus();
                    }
                });
            }
        }
    }

    private class EnabledCellRenderer
    extends DefaultTableCellRenderer {
        private TableCellRenderer myDelegate;

        public EnabledCellRenderer(TableCellRenderer delegate) {
            this.myDelegate = delegate;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.myDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setEnabled(ClassFilterEditor.this.isEnabled());
            return component;
        }
    }

    private class FilterCellRenderer
    extends DefaultTableCellRenderer {
        private FilterCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color = UIUtil.getTableFocusCellBackground();
            UIManager.put("Table.focusCellBackground", table.getSelectionBackground());
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (component instanceof JLabel) {
                ((JLabel)component).setBorder(noFocusBorder);
            }
            UIManager.put("Table.focusCellBackground", color);
            ClassFilter filter = (ClassFilter)table.getValueAt(row, 1);
            component.setEnabled(ClassFilterEditor.this.isEnabled() && filter.isEnabled());
            return component;
        }
    }

    protected final class FilterTableModel
    extends AbstractTableModel {
        private List<ClassFilter> myFilters = new LinkedList<ClassFilter>();
        public static final int CHECK_MARK = 0;
        public static final int FILTER = 1;

        protected FilterTableModel() {
        }

        public final void setFilters(ClassFilter[] filters) {
            this.myFilters.clear();
            if (filters != null) {
                for (ClassFilter filter : filters) {
                    this.myFilters.add(filter);
                }
            }
            this.fireTableDataChanged();
        }

        public ClassFilter[] getFilters() {
            Iterator<ClassFilter> it = this.myFilters.iterator();
            while (it.hasNext()) {
                ClassFilter filter = it.next();
                String pattern = filter.getPattern();
                if (pattern != null && !"".equals(pattern)) continue;
                it.remove();
            }
            return this.myFilters.toArray(new ClassFilter[this.myFilters.size()]);
        }

        public ClassFilter getFilterAt(int index) {
            return this.myFilters.get(index);
        }

        public int getFilterIndex(ClassFilter filter) {
            return this.myFilters.indexOf(filter);
        }

        public void addRow(ClassFilter filter) {
            this.myFilters.add(filter);
            int row = this.myFilters.size() - 1;
            this.fireTableRowsInserted(row, row);
        }

        public void removeRows(int[] rows) {
            LinkedList<ClassFilter> toRemove = new LinkedList<ClassFilter>();
            for (int row : rows) {
                toRemove.add(this.myFilters.get(row));
            }
            this.myFilters.removeAll(toRemove);
            toRemove.clear();
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.myFilters.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            ClassFilter filter = this.myFilters.get(rowIndex);
            if (columnIndex == 1) {
                return filter;
            }
            if (columnIndex == 0) {
                return filter.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
            return null;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ClassFilter filter = this.myFilters.get(rowIndex);
            if (columnIndex == 1) {
                filter.setPattern(aValue != null ? aValue.toString() : "");
            } else if (columnIndex == 0) {
                filter.setEnabled(aValue == null || (Boolean)aValue != false);
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (ClassFilterEditor.this.isEnabled()) {
                return columnIndex == 0;
            }
            return false;
        }
    }
}

