/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.awt;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RelativePoint {
    private Component myComponent;
    private Point myPointOnComponent;

    public RelativePoint(MouseEvent event) {
        this(event.getComponent(), event.getPoint());
    }

    public RelativePoint(Component aComponent, Point aPointOnComponent) {
        if (aComponent.isShowing()) {
            this.myComponent = SwingUtilities.getRootPane(aComponent);
            this.myPointOnComponent = SwingUtilities.convertPoint(aComponent, aPointOnComponent, this.myComponent);
        } else {
            this.myComponent = aComponent;
            this.myPointOnComponent = aPointOnComponent;
        }
    }

    public Component getComponent() {
        return this.myComponent;
    }

    public Point getPoint() {
        return this.myPointOnComponent;
    }

    public Point getPoint(Component aTargetComponent) {
        if (aTargetComponent == null || aTargetComponent.getParent() == null || SwingUtilities.getWindowAncestor(aTargetComponent) == null) {
            return new Point();
        }
        return SwingUtilities.convertPoint(this.getComponent(), this.getPoint(), aTargetComponent);
    }

    public RelativePoint getPointOn(Component aTargetComponent) {
        Point point = this.getPoint(aTargetComponent);
        return new RelativePoint(aTargetComponent, point);
    }

    public Point getScreenPoint() {
        Point point = (Point)this.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, this.getComponent());
        return point;
    }

    public String toString() {
        return this.getPoint() + " on " + this.getComponent().toString();
    }

    public static RelativePoint getCenterOf(JComponent component) {
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
        return new RelativePoint(component, point);
    }

    public static RelativePoint getSouthEastOf(JComponent component) {
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height);
        return new RelativePoint(component, point);
    }

    public static RelativePoint getSouthWestOf(JComponent component) {
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x, visibleRect.y + visibleRect.height);
        return new RelativePoint(component, point);
    }

    public static RelativePoint getNorthWestOf(JComponent component) {
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x, visibleRect.y);
        return new RelativePoint(component, point);
    }

    public static RelativePoint getNorthEastOf(JComponent component) {
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width, visibleRect.y);
        return new RelativePoint(component, point);
    }
}

