/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.ui.ComponentTreeWatcher;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.UserActivityListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class UserActivityWatcher
extends ComponentTreeWatcher {
    private boolean myIsModified = false;
    private EventDispatcher<UserActivityListener> myListeners = EventDispatcher.create(UserActivityListener.class);
    private final DocumentListener myDocumentListener = new DocumentAdapter(){

        public void textChanged(DocumentEvent event) {
            UserActivityWatcher.this.fireUIChanged();
        }
    };
    private TableModelListener myTableModelListener = new TableModelListener(){

        public void tableChanged(TableModelEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }
    };
    private PropertyChangeListener myTableListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            TableModel newModel;
            TableModel oldModel = (TableModel)evt.getOldValue();
            if (oldModel != null) {
                oldModel.removeTableModelListener(UserActivityWatcher.this.myTableModelListener);
            }
            if ((newModel = (TableModel)evt.getNewValue()) != null) {
                newModel.addTableModelListener(UserActivityWatcher.this.myTableModelListener);
            }
            if (oldModel != null) {
                UserActivityWatcher.this.fireUIChanged();
            }
        }
    };
    private final ItemListener myItemListener = new ItemListener(){

        public void itemStateChanged(ItemEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }
    };
    private final ListDataListener myListDataListener = new ListDataListener(){

        public void intervalAdded(ListDataEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }

        public void intervalRemoved(ListDataEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }

        public void contentsChanged(ListDataEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }
    };
    private final TreeModelListener myTreeModelListener = new TreeModelListener(){

        public void treeNodesChanged(TreeModelEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }

        public void treeNodesInserted(TreeModelEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }

        public void treeStructureChanged(TreeModelEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }
    };

    public void addUserActivityListener(UserActivityListener listener) {
        this.myListeners.addListener(listener);
    }

    public void addUserActivityListener(UserActivityListener listener, Disposable parentDisposable) {
        this.myListeners.addListener(listener, parentDisposable);
    }

    public void removeUserActivityListener(UserActivityListener listener) {
        this.myListeners.removeListener(listener);
    }

    protected final void fireUIChanged() {
        this.myIsModified = true;
        this.myListeners.getMulticaster().stateChanged();
    }

    public UserActivityWatcher(Class[] controlsToIgnore) {
        super(controlsToIgnore);
    }

    public UserActivityWatcher() {
        this(ArrayUtil.EMPTY_CLASS_ARRAY);
    }

    protected void processComponent(Component parentComponent) {
        ComboBoxEditor editor;
        if (parentComponent instanceof JTextComponent) {
            ((JTextComponent)parentComponent).getDocument().addDocumentListener(this.myDocumentListener);
        } else if (parentComponent instanceof ItemSelectable) {
            ((ItemSelectable)((Object)parentComponent)).addItemListener(this.myItemListener);
        } else if (parentComponent instanceof JList) {
            ((JList)parentComponent).getModel().addListDataListener(this.myListDataListener);
        } else if (parentComponent instanceof JTree) {
            ((JTree)parentComponent).getModel().addTreeModelListener(this.myTreeModelListener);
        }
        if (parentComponent instanceof JComboBox && (editor = ((JComboBox)parentComponent).getEditor()) != null) {
            this.register(editor.getEditorComponent());
        }
        if (parentComponent instanceof JTable) {
            JTable table = (JTable)parentComponent;
            table.addPropertyChangeListener("model", this.myTableListener);
            TableModel model = table.getModel();
            if (model != null) {
                model.addTableModelListener(this.myTableModelListener);
            }
        }
    }

    protected void unprocessComponent(Component component) {
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).getDocument().removeDocumentListener(this.myDocumentListener);
        } else if (component instanceof ItemSelectable) {
            ((ItemSelectable)((Object)component)).removeItemListener(this.myItemListener);
        } else if (component instanceof JTree) {
            ((JTree)component).getModel().removeTreeModelListener(this.myTreeModelListener);
        }
        if (component instanceof JTable) {
            component.removePropertyChangeListener(this.myTableListener);
            TableModel model = ((JTable)component).getModel();
            if (model != null) {
                model.removeTableModelListener(this.myTableModelListener);
            }
        }
    }

    public boolean isModified() {
        return this.myIsModified;
    }

    public void commit() {
        this.myIsModified = false;
    }
}

