/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.awt.RelativePoint;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreeUtils {
    private TreeUtils() {
    }

    public static RelativePoint getPointForSelection(JTree aTree) {
        int[] rows = aTree.getSelectionRows();
        if (rows == null || rows.length == 0) {
            return RelativePoint.getCenterOf(aTree);
        }
        return TreeUtils.getPointForRow(aTree, rows[rows.length - 1]);
    }

    public static RelativePoint getPointForRow(JTree aTree, int aRow) {
        return TreeUtils.getPointForPath(aTree, aTree.getPathForRow(aRow));
    }

    public static RelativePoint getPointForPath(JTree aTree, TreePath path) {
        Rectangle rowBounds = aTree.getPathBounds(path);
        rowBounds.x += 20;
        return TreeUtils.getPointForBounds(aTree, rowBounds);
    }

    private static RelativePoint getPointForBounds(JComponent aComponent, Rectangle aBounds) {
        return new RelativePoint(aComponent, new Point(aBounds.x, (int)aBounds.getMaxY()));
    }

    public static boolean isOverSelection(JTree tree, Point point) {
        TreePath path = tree.getPathForLocation(point.x, point.y);
        return path != null && tree.getSelectionModel().isPathSelected(path);
    }

    public static void dropSelectionButUnderPoint(JTree tree, Point treePoint) {
        TreePath toRetain = tree.getPathForLocation(treePoint.x, treePoint.y);
        if (toRetain == null) {
            return;
        }
        TreePath[] selection = tree.getSelectionModel().getSelectionPaths();
        for (TreePath each : selection = selection == null ? new TreePath[]{} : selection) {
            if (toRetain.equals(each)) continue;
            tree.getSelectionModel().removeSelectionPath(each);
        }
    }
}

