/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.datatransfer.Clipboard;
import javax.swing.JTree;

public class TreeCopyProvider
implements CopyProvider {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ui.TreeCopyProvider");
    private JTree myTree;

    public TreeCopyProvider(JTree tree) {
        this.myTree = tree;
    }

    public void performCopy(DataContext dataContext) {
        try {
            Clipboard clipboard = this.myTree.getToolkit().getSystemClipboard();
            this.myTree.getTransferHandler().exportToClipboard(this.myTree, clipboard, 1);
        }
        catch (Exception ex) {
            LOG.info(ex);
        }
    }

    public boolean isCopyEnabled(DataContext dataContext) {
        return this.myTree.getSelectionPath() != null;
    }
}

