/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CaptionPanel;
import com.intellij.ui.PopupBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class TitlePanel
extends CaptionPanel {
    private JLabel myLabel;
    private Icon myRegular;
    private Icon myInactive;

    public TitlePanel() {
        this(null, null);
    }

    public TitlePanel(Icon regular, Icon inactive) {
        this.myRegular = regular;
        this.myInactive = inactive;
        this.myLabel = new JLabel();
        this.myLabel.setOpaque(false);
        this.myLabel.setForeground(Color.black);
        this.myLabel.setHorizontalAlignment(0);
        this.myLabel.setVerticalAlignment(0);
        this.myLabel.setBorder(new EmptyBorder(1, 2, 2, 2));
        this.add((Component)this.myLabel, "Center");
        this.setActive(false);
    }

    public void setFontBold(boolean bold) {
        this.myLabel.setFont(this.myLabel.getFont().deriveFont(bold ? 1 : 0));
    }

    public void setActive(boolean active) {
        super.setActive(active);
        this.myLabel.setIcon(active ? this.myRegular : this.myInactive);
        this.myLabel.setForeground(active ? UIManager.getColor("Label.foreground") : Color.gray);
    }

    public void setText(String titleText) {
        this.myLabel.setText(titleText);
    }

    public Dimension getPreferredSize() {
        String text = this.myLabel.getText();
        return text != null && text.trim().length() > 0 ? super.getPreferredSize() : new Dimension(0, 0);
    }

    public static void main(String[] args) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().setBackground(Color.white);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.white);
        jPanel.setOpaque(true);
        jPanel.setBorder(PopupBorder.Factory.create(true));
        jFrame.getContentPane().add(jPanel);
        jFrame.setBounds(100, 100, 200, 200);
        jFrame.setVisible(true);
    }
}

