/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public class TextComponentUndoProvider
implements Disposable {
    private JTextComponent myTextComponent;
    private UndoManager myUndoManager = new UndoManager();
    private UndoableEditListener myUndoableEditListener;
    private javax.swing.text.Keymap myOldKeymap;

    public TextComponentUndoProvider(JTextComponent textComponent) {
        this.myTextComponent = textComponent;
        this.myUndoableEditListener = new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent e) {
                TextComponentUndoProvider.this.myUndoManager.addEdit(e.getEdit());
            }
        };
        this.myTextComponent.getDocument().addUndoableEditListener(this.myUndoableEditListener);
        this.myOldKeymap = this.myTextComponent.getKeymap();
        javax.swing.text.Keymap keymap = JTextComponent.addKeymap(null, this.myOldKeymap);
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] undoShortcuts = activeKeymap.getShortcuts("$Undo");
        Shortcut[] redoShortcuts = activeKeymap.getShortcuts("$Redo");
        AbstractAction undoAction = new AbstractAction("Undo"){

            public void actionPerformed(ActionEvent e) {
                if (TextComponentUndoProvider.this.myUndoManager.canUndo()) {
                    TextComponentUndoProvider.this.myUndoManager.undo();
                }
            }
        };
        AbstractAction redoAction = new AbstractAction("Redo"){

            public void actionPerformed(ActionEvent e) {
                if (TextComponentUndoProvider.this.myUndoManager.canRedo()) {
                    TextComponentUndoProvider.this.myUndoManager.redo();
                }
            }
        };
        for (Shortcut undoShortcut : undoShortcuts) {
            if (!(undoShortcut instanceof KeyboardShortcut)) continue;
            keymap.addActionForKeyStroke(((KeyboardShortcut)undoShortcut).getFirstKeyStroke(), undoAction);
        }
        for (Shortcut redoShortcut : redoShortcuts) {
            if (!(redoShortcut instanceof KeyboardShortcut)) continue;
            keymap.addActionForKeyStroke(((KeyboardShortcut)redoShortcut).getFirstKeyStroke(), redoAction);
        }
        this.myTextComponent.setKeymap(keymap);
    }

    public void dispose() {
        if (this.myUndoableEditListener != null) {
            this.myTextComponent.getDocument().removeUndoableEditListener(this.myUndoableEditListener);
            this.myUndoableEditListener = null;
        }
        if (this.myOldKeymap != null) {
            this.myTextComponent.setKeymap(this.myOldKeymap);
            this.myOldKeymap = null;
        }
    }
}

