/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.ItemRemovable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableUtil {
    public static List<Object[]> removeSelectedItems(JTable table) {
        return TableUtil.removeSelectedItems(table, null);
    }

    public static void selectRows(JTable table, int[] rows) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.clearSelection();
        int count = table.getRowCount();
        for (int row : rows) {
            if (row < 0 || row >= count) continue;
            selectionModel.addSelectionInterval(row, row);
        }
    }

    public static void scrollSelectionToVisible(JTable table) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        if (maxSelectionIndex == -1) {
            return;
        }
        Rectangle minCellRect = table.getCellRect(minSelectionIndex, 0, false);
        Rectangle maxCellRect = table.getCellRect(maxSelectionIndex, 0, false);
        Point selectPoint = minCellRect.getLocation();
        int allHeight = maxCellRect.y + maxCellRect.height - minCellRect.y;
        allHeight = Math.min(allHeight, table.getVisibleRect().height);
        table.scrollRectToVisible(new Rectangle(selectPoint, new Dimension(1, allHeight)));
    }

    public static List<Object[]> removeSelectedItems(JTable table, ItemChecker applyable) {
        TableModel model;
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
        if (!((model = table.getModel()) instanceof ItemRemovable)) {
            throw new RuntimeException("model must be instance of ItemRemovable");
        }
        ListSelectionModel selectionModel = table.getSelectionModel();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        if (minSelectionIndex == -1) {
            return new ArrayList<Object[]>(0);
        }
        LinkedList<Object[]> removedItems = new LinkedList<Object[]>();
        int columnCount = model.getColumnCount();
        for (int idx = table.getRowCount() - 1; idx >= 0; --idx) {
            if (!selectionModel.isSelectedIndex(idx) || applyable != null && !applyable.isOperationApplyable(model, idx)) continue;
            Object[] row = new Object[columnCount];
            for (int column = 0; column < columnCount; ++column) {
                row[column] = model.getValueAt(idx, column);
            }
            removedItems.add(0, row);
            ((ItemRemovable)((Object)model)).removeRow(idx);
        }
        int count = model.getRowCount();
        if (count == 0) {
            table.clearSelection();
        } else {
            int selectionIndex = selectionModel.getMinSelectionIndex();
            if (selectionIndex < 0 || selectionIndex >= count) {
                int rowToSelect = Math.min(count - 1, selectionIndex);
                selectionModel.setSelectionInterval(rowToSelect, rowToSelect);
            }
        }
        return removedItems;
    }

    public static int moveSelectedItemsUp(JTable table) {
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
        TableModel model = table.getModel();
        ListSelectionModel selectionModel = table.getSelectionModel();
        int counter = 0;
        for (int row = 0; row < model.getRowCount(); ++row) {
            if (!selectionModel.isSelectedIndex(row)) continue;
            ++counter;
            for (int column = 0; column < model.getColumnCount(); ++column) {
                Object temp = model.getValueAt(row, column);
                model.setValueAt(model.getValueAt(row - 1, column), row, column);
                model.setValueAt(temp, row - 1, column);
            }
            selectionModel.removeSelectionInterval(row, row);
            selectionModel.addSelectionInterval(row - 1, row - 1);
        }
        Rectangle cellRect = table.getCellRect(selectionModel.getMinSelectionIndex(), 0, true);
        if (cellRect != null) {
            table.scrollRectToVisible(cellRect);
        }
        table.repaint();
        return counter;
    }

    public static int moveSelectedItemsDown(JTable table) {
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
        TableModel model = table.getModel();
        ListSelectionModel selectionModel = table.getSelectionModel();
        int counter = 0;
        for (int row = model.getRowCount() - 1; row >= 0; --row) {
            if (!selectionModel.isSelectedIndex(row)) continue;
            ++counter;
            for (int column = 0; column < model.getColumnCount(); ++column) {
                Object temp = model.getValueAt(row, column);
                model.setValueAt(model.getValueAt(row + 1, column), row, column);
                model.setValueAt(temp, row + 1, column);
            }
            selectionModel.removeSelectionInterval(row, row);
            selectionModel.addSelectionInterval(row + 1, row + 1);
        }
        Rectangle cellRect = table.getCellRect(selectionModel.getMaxSelectionIndex(), 0, true);
        if (cellRect != null) {
            table.scrollRectToVisible(cellRect);
        }
        table.repaint();
        return counter;
    }

    public static void editCellAt(JTable table, int row, int column) {
        Component component;
        if (table.editCellAt(row, column) && (component = table.getEditorComponent()) != null) {
            component.requestFocus();
        }
    }

    public static void stopEditing(JTable table) {
        if (table.isEditing()) {
            TableCellEditor editor;
            TableCellEditor cellEditor = table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
            int row = table.getSelectedRow();
            int column = table.getSelectedColumn();
            if (row >= 0 && column >= 0 && (editor = table.getCellEditor(row, column)) != null) {
                editor.stopCellEditing();
            }
        }
    }

    public static void ensureSelectionExists(JTable table) {
        if (table.getSelectedRow() != -1 || table.getRowCount() == 0) {
            return;
        }
        table.setRowSelectionInterval(0, 0);
    }

    public static interface ItemChecker {
        public boolean isOperationApplyable(TableModel var1, int var2);
    }
}

