/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;

public final class SimpleTextAttributes {
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int FONT_MASK = 3;
    public static final int STYLE_STRIKEOUT = 4;
    public static final int STYLE_WAVED = 8;
    public static final int STYLE_UNDERLINE = 16;
    private final Color myBgColor;
    private final Color myFgColor;
    private final Color myWaveColor;
    private final int myStyle;
    public static final SimpleTextAttributes REGULAR_ATTRIBUTES = new SimpleTextAttributes(0, null);
    public static final SimpleTextAttributes REGULAR_BOLD_ATTRIBUTES = new SimpleTextAttributes(1, null);
    public static final SimpleTextAttributes ERROR_ATTRIBUTES = new SimpleTextAttributes(0, Color.red);
    public static final SimpleTextAttributes GRAYED_ATTRIBUTES = new SimpleTextAttributes(0, UIUtil.getTextInactiveTextColor());
    public static final SimpleTextAttributes GRAYED_BOLD_ATTRIBUTES = new SimpleTextAttributes(1, UIUtil.getTextInactiveTextColor());
    public static final SimpleTextAttributes SYNTHETIC_ATTRIBUTES = new SimpleTextAttributes(0, Color.BLUE);
    public static final SimpleTextAttributes GRAY_ATTRIBUTES = new SimpleTextAttributes(0, Color.GRAY);
    public static final SimpleTextAttributes GRAY_ITALIC_ATTRIBUTES = new SimpleTextAttributes(2, Color.GRAY);
    public static final SimpleTextAttributes DARK_TEXT = new SimpleTextAttributes(0, new Color(112, 112, 164));
    public static final SimpleTextAttributes SIMPLE_CELL_ATTRIBUTES = new SimpleTextAttributes(0, UIUtil.getListForeground());
    public static final SimpleTextAttributes SELECTED_SIMPLE_CELL_ATTRIBUTES = new SimpleTextAttributes(0, UIUtil.getListSelectionForeground());
    public static final SimpleTextAttributes EXCLUDED_ATTRIBUTES = new SimpleTextAttributes(2, Color.GRAY);
    public static final SimpleTextAttributes LINK_ATTRIBUTES = new SimpleTextAttributes(16, Color.blue);
    public static final SimpleTextAttributes LINK_BOLD_ATTRIBUTES = new SimpleTextAttributes(17, Color.blue);

    public SimpleTextAttributes(int style, Color fgColor) {
        this(style, fgColor, null);
    }

    public SimpleTextAttributes(Color bgColor, Color fgColor, Color waveColor, int style) {
        if ((0xFFFFFFE0 & style) != 0) {
            throw new IllegalArgumentException("wrong style: " + style);
        }
        this.myFgColor = fgColor;
        this.myWaveColor = waveColor;
        this.myStyle = style;
        this.myBgColor = bgColor;
    }

    public SimpleTextAttributes(int style, Color fgColor, Color waveColor) {
        this(null, fgColor, waveColor, style);
    }

    public Color getFgColor() {
        return this.myFgColor;
    }

    public Color getBgColor() {
        return this.myBgColor;
    }

    public Color getWaveColor() {
        return this.myWaveColor;
    }

    public int getStyle() {
        return this.myStyle;
    }

    public boolean isStrikeout() {
        return (this.myStyle & 4) != 0;
    }

    public boolean isWaved() {
        return (this.myStyle & 8) != 0;
    }

    public boolean isUnderline() {
        return (this.myStyle & 0x10) != 0;
    }

    public static SimpleTextAttributes fromTextAttributes(TextAttributes attributes) {
        if (attributes == null) {
            return REGULAR_ATTRIBUTES;
        }
        Color foregroundColor = attributes.getForegroundColor();
        if (foregroundColor == null) {
            foregroundColor = REGULAR_ATTRIBUTES.getFgColor();
        }
        int style = attributes.getFontType();
        if (attributes.getEffectColor() != null) {
            EffectType effectType = attributes.getEffectType();
            if (effectType == EffectType.STRIKEOUT) {
                style |= 4;
            } else if (effectType == EffectType.WAVE_UNDERSCORE) {
                style |= 8;
            } else if (effectType == EffectType.LINE_UNDERSCORE) {
                style |= 0x10;
            }
        }
        return new SimpleTextAttributes(attributes.getBackgroundColor(), foregroundColor, attributes.getEffectColor(), style);
    }

    public TextAttributes toTextAttributes() {
        EffectType effectType;
        Color effectColor;
        if (this.isWaved()) {
            effectColor = this.myWaveColor;
            effectType = EffectType.WAVE_UNDERSCORE;
        } else if (this.isStrikeout()) {
            effectColor = this.myWaveColor;
            effectType = EffectType.STRIKEOUT;
        } else if (this.isUnderline()) {
            effectColor = this.myWaveColor;
            effectType = EffectType.LINE_UNDERSCORE;
        } else {
            effectColor = null;
            effectType = null;
        }
        return new TextAttributes(this.myFgColor, null, effectColor, effectType, this.myStyle & 3);
    }
}

