/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.peer.PeerFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class SimpleColoredComponent
extends JComponent {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ui.SimpleColoredComponent");
    private final ArrayList<String> myFragments = new ArrayList(3);
    private final ArrayList<SimpleTextAttributes> myAttributes = new ArrayList(3);
    private ArrayList<Object> myFragmentTags = null;
    private Icon myIcon;
    private Insets myIpad = new Insets(1, 2, 1, 2);
    private int myIconTextGap = 2;
    private boolean myPaintFocusBorder;
    private boolean myFocusBorderAroundIcon;
    private final MyBorder myBorder = new MyBorder();
    private int myMainTextLastIndex = -1;
    private int myAlignIndex;
    private int myAlignWidth;

    public SimpleColoredComponent() {
        this.setOpaque(true);
    }

    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/SimpleColoredComponent.append must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/SimpleColoredComponent.append must not be null");
        }
        this.append(fragment, attributes, this.myMainTextLastIndex < 0);
    }

    public synchronized void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/SimpleColoredComponent.append must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/SimpleColoredComponent.append must not be null");
        }
        this.myFragments.add(fragment);
        this.myAttributes.add(attributes);
        if (isMainText) {
            this.myMainTextLastIndex = this.myFragments.size() - 1;
        }
    }

    public synchronized void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, Object tag) {
        if (fragment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/SimpleColoredComponent.append must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/SimpleColoredComponent.append must not be null");
        }
        this.append(fragment, attributes);
        if (this.myFragmentTags == null) {
            this.myFragmentTags = new ArrayList();
        }
        while (this.myFragmentTags.size() < this.myFragments.size() - 1) {
            this.myFragmentTags.add(null);
        }
        this.myFragmentTags.add(tag);
    }

    public synchronized void appendAlign(int alignWidth) {
        this.myAlignIndex = this.myFragments.size() - 1;
        this.myAlignWidth = alignWidth;
    }

    public synchronized void clear() {
        this.myIcon = null;
        this.myPaintFocusBorder = false;
        this.setBorder(null);
        this.myFragments.clear();
        this.myAttributes.clear();
        this.myFragmentTags = null;
        this.myMainTextLastIndex = -1;
        this.myAlignIndex = -1;
        this.myAlignWidth = -1;
    }

    public final Icon getIcon() {
        return this.myIcon;
    }

    public final void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public Insets getIpad() {
        return this.myIpad;
    }

    public void setIpad(Insets ipad) {
        this.myIpad = ipad;
    }

    public int getIconTextGap() {
        return this.myIconTextGap;
    }

    public void setIconTextGap(int iconTextGap) {
        if (iconTextGap < 0) {
            throw new IllegalArgumentException("wrong iconTextGap: " + iconTextGap);
        }
        this.myIconTextGap = iconTextGap;
    }

    protected final void setPaintFocusBorder(boolean paintFocusBorder) {
        this.myPaintFocusBorder = paintFocusBorder;
    }

    protected final void setFocusBorderAroundIcon(boolean focusBorderAroundIcon) {
        this.myFocusBorderAroundIcon = focusBorderAroundIcon;
    }

    public Dimension getPreferredSize() {
        return this.computePreferredSize(false);
    }

    public synchronized Object getFragmentTag(int index) {
        if (this.myFragmentTags != null && index < this.myFragmentTags.size()) {
            return this.myFragmentTags.get(index);
        }
        return null;
    }

    public final synchronized Dimension computePreferredSize(boolean mainTextOnly) {
        int width = this.myIpad.left;
        if (this.myIcon != null) {
            width += this.myIcon.getIconWidth() + this.myIconTextGap;
        }
        Insets borderInsets = this.myBorder.getBorderInsets(this);
        width += borderInsets.left;
        Font font = this.getFont();
        LOG.assertTrue(font != null);
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            if (font.getStyle() != attributes.getStyle()) {
                font = font.deriveFont(attributes.getStyle());
            }
            FontMetrics metrics = this.getFontMetrics(font);
            if (i == this.myAlignIndex && (width += metrics.stringWidth(this.myFragments.get(i))) < this.myAlignWidth) {
                width = this.myAlignWidth;
            }
            if (mainTextOnly && this.myMainTextLastIndex >= 0 && i == this.myMainTextLastIndex) break;
        }
        width += this.myIpad.right + borderInsets.right;
        int height = this.myIpad.top + this.myIpad.bottom;
        FontMetrics metrics = this.getFontMetrics(font);
        int textHeight = metrics.getHeight();
        height = this.myIcon != null ? (height += Math.max(this.myIcon.getIconHeight(), textHeight)) : (height += (textHeight += borderInsets.top + borderInsets.bottom));
        Insets insets = this.getInsets();
        return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    public int findFragmentAt(int x) {
        Font font;
        int curX = this.myIpad.left;
        if (this.myIcon != null) {
            curX += this.myIcon.getIconWidth() + this.myIconTextGap;
        }
        LOG.assertTrue((font = this.getFont()) != null);
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            if (font.getStyle() != attributes.getStyle()) {
                font = font.deriveFont(attributes.getStyle());
            }
            FontMetrics metrics = this.getFontMetrics(font);
            int curWidth = metrics.stringWidth(this.myFragments.get(i));
            if (x >= curX && x < curX + curWidth) {
                return i;
            }
            if (i != this.myAlignIndex || (curX += curWidth) >= this.myAlignWidth) continue;
            curX = this.myAlignWidth;
        }
        return -1;
    }

    protected void paintComponent(Graphics g) {
        try {
            this.doPaint(g);
        }
        catch (RuntimeException e) {
            LOG.error(this.logSwingPath(), e);
            throw e;
        }
    }

    protected synchronized void doPaint(Graphics g) {
        SimpleColoredComponent.checkCanPaint();
        int xOffset = 0;
        Icon icon = this.myIcon;
        if (icon != null) {
            Container parent = this.getParent();
            Color iconBackgroundColor = parent != null && !this.myFocusBorderAroundIcon && !UIUtil.isUnderQuaquaLookAndFeel() ? parent.getBackground() : this.getBackground();
            g.setColor(iconBackgroundColor);
            g.fillRect(0, 0, icon.getIconWidth() + this.myIpad.left + this.myIconTextGap, this.getHeight());
            icon.paintIcon(this, g, this.myIpad.left, (this.getHeight() - icon.getIconHeight()) / 2);
            xOffset += this.myIpad.left + icon.getIconWidth() + this.myIconTextGap;
        }
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(xOffset, 0, this.getWidth() - xOffset, this.getHeight());
        }
        if (xOffset == 0) {
            xOffset = this.myIpad.left;
        }
        if (this.myPaintFocusBorder) {
            if (this.myFocusBorderAroundIcon || icon == null) {
                this.myBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            } else {
                this.myBorder.paintBorder(this, g, xOffset, 0, this.getWidth() - xOffset, this.getHeight());
            }
        }
        xOffset += this.myBorder.getBorderInsets((Component)this).left;
        UIUtil.applyRenderingHints(g);
        for (int i = 0; i < this.myFragments.size(); ++i) {
            Color color;
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            Font font = this.getFont();
            if (font.getStyle() != attributes.getStyle()) {
                font = font.deriveFont(attributes.getStyle());
            }
            g.setFont(font);
            FontMetrics metrics = this.getFontMetrics(font);
            String fragment = this.myFragments.get(i);
            int fragmentWidth = metrics.stringWidth(fragment);
            Color bgColor = attributes.getBgColor();
            if (this.isOpaque() && bgColor != null) {
                g.setColor(bgColor);
                g.fillRect(xOffset, 0, fragmentWidth, this.getHeight());
            }
            if ((color = attributes.getFgColor()) == null) {
                color = this.getForeground();
            }
            if (!this.isEnabled()) {
                color = UIUtil.getTextInactiveTextColor();
            }
            g.setColor(color);
            int textBaseline = (this.getHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
            g.drawString(fragment, xOffset, textBaseline);
            if (attributes.isStrikeout()) {
                int strikeOutAt = textBaseline + (metrics.getDescent() - metrics.getAscent()) / 2;
                UIUtil.drawLine(g, xOffset, strikeOutAt, xOffset + fragmentWidth, strikeOutAt);
            }
            if (attributes.isWaved()) {
                if (attributes.getWaveColor() != null) {
                    g.setColor(attributes.getWaveColor());
                }
                int wavedAt = textBaseline + 1;
                for (int x = xOffset; x <= xOffset + fragmentWidth; x += 4) {
                    UIUtil.drawLine(g, x, wavedAt, x + 2, wavedAt + 2);
                    UIUtil.drawLine(g, x + 3, wavedAt + 1, x + 4, wavedAt);
                }
            }
            if (attributes.isUnderline()) {
                int underlineAt = textBaseline + 1;
                UIUtil.drawLine(g, xOffset, underlineAt, xOffset + fragmentWidth, underlineAt);
            }
            if (i != this.myAlignIndex || (xOffset += fragmentWidth) >= this.myAlignWidth) continue;
            xOffset = this.myAlignWidth;
        }
    }

    private static void checkCanPaint() {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            application.assertIsDispatchThread();
        } else if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException(Thread.currentThread().toString());
        }
    }

    private String logSwingPath() {
        StringBuilder buffer = new StringBuilder("Components hierarchy:\n");
        for (Container c = this; c != null; c = c.getParent()) {
            buffer.append('\n');
            buffer.append(c.toString());
        }
        return buffer.toString();
    }

    private static final class MyBorder
    implements Border {
        private final Insets myInsets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.BLACK);
            PeerFactory.getInstance().getUIHelper().drawDottedRectangle(g, x, y, x + width - 1, y + height - 1);
        }

        public Insets getBorderInsets(Component c) {
            return this.myInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

