/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.LineBorder;

public class SideBorder
extends LineBorder {
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 8;
    public static final int ALL = 15;
    private int mySideMask;

    public SideBorder(Color color, int mask) {
        super(color, 1);
        this.mySideMask = mask;
    }

    public Insets getBorderInsets(Component component) {
        return new Insets((this.mySideMask & 2) != 0 ? this.getThickness() : 0, (this.mySideMask & 1) != 0 ? this.getThickness() : 0, (this.mySideMask & 8) != 0 ? this.getThickness() : 0, (this.mySideMask & 4) != 0 ? this.getThickness() : 0);
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = (this.mySideMask & 2) != 0 ? this.getThickness() : 0;
        insets.left = (this.mySideMask & 1) != 0 ? this.getThickness() : 0;
        insets.bottom = (this.mySideMask & 8) != 0 ? this.getThickness() : 0;
        insets.right = (this.mySideMask & 4) != 0 ? this.getThickness() : 0;
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.getLineColor());
        for (int i = 0; i < this.getThickness(); ++i) {
            if ((this.mySideMask & 1) != 0) {
                UIUtil.drawLine(g, x + i, y + i, x + i, height - i - i - 1);
            }
            if ((this.mySideMask & 2) != 0) {
                UIUtil.drawLine(g, x + i, y + i, width - i - i - 1, y + i);
            }
            if ((this.mySideMask & 4) != 0) {
                UIUtil.drawLine(g, width - i - i - 1, y + i, width - i - i - 1, height - i - i - 1);
            }
            if ((this.mySideMask & 8) == 0) continue;
            UIUtil.drawLine(g, x + i, height - i - i - 1, width - i - i - 1, height - i - i - 1);
        }
        g.setColor(oldColor);
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }
}

