/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ListUtil;
import com.intellij.ui.SortedListModel;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReorderableListController<T> {
    private final JList myList;
    private static final Icon REMOVE_ICON = IconLoader.getIcon("/general/remove.png");
    private static final Icon COPY_ICON = IconLoader.getIcon("/actions/copy.png");

    protected ReorderableListController(JList list) {
        this.myList = list;
    }

    public JList getList() {
        return this.myList;
    }

    public RemoveActionDescription addRemoveAction(String actionName) {
        RemoveActionDescription description = new RemoveActionDescription(actionName);
        this.addActionDescription(description);
        return description;
    }

    protected abstract void addActionDescription(ActionDescription var1);

    public AddActionDescription addAddAction(String actionName, Factory<T> creator, boolean createShortcut) {
        AddActionDescription description = new AddActionDescription(actionName, creator, createShortcut);
        this.addActionDescription(description);
        return description;
    }

    public CopyActionDescription addCopyAction(String actionName, Convertor<T, T> copier, Condition<T> enableCondition) {
        CopyActionDescription description = new CopyActionDescription(actionName, copier, enableCondition);
        this.addActionDescription(description);
        return description;
    }

    public void addMoveUpAction() {
        this.addAction(new AnAction(ExecutionBundle.message("move.up.action.name", new Object[0]), null, IconLoader.getIcon("/actions/moveUp.png")){

            public void actionPerformed(AnActionEvent e) {
                ListUtil.moveSelectedItemsUp(ReorderableListController.this.myList);
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(ListUtil.canMoveSelectedItemsUp(ReorderableListController.this.myList));
            }
        });
    }

    public void addMoveDownAction() {
        this.addAction(new AnAction(ExecutionBundle.message("move.down.action.name", new Object[0]), null, IconLoader.getIcon("/actions/moveDown.png")){

            public void actionPerformed(AnActionEvent e) {
                ListUtil.moveSelectedItemsDown(ReorderableListController.this.myList);
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(ListUtil.canMoveSelectedItemsDown(ReorderableListController.this.myList));
            }
        });
    }

    public void addAction(AnAction action) {
        this.addActionDescription(new FixedActionDescription(action));
    }

    private void handleNewElement(T element) {
        ListModel listModel = this.myList.getModel();
        if (listModel instanceof SortedListModel) {
            ((SortedListModel)listModel).add(element);
        } else {
            ((DefaultListModel)listModel).addElement(element);
        }
        this.myList.clearSelection();
        ListScrollingUtil.selectItem(this.myList, element);
    }

    public static <T> ReorderableListController<T> create(final JList list, final DefaultActionGroup actionGroup) {
        return new ReorderableListController<T>(list){

            @Override
            protected void addActionDescription(ActionDescription description) {
                actionGroup.add(description.createAction(list));
            }
        };
    }

    private static class FixedActionDescription
    extends ActionDescription {
        private final AnAction myAction;

        public FixedActionDescription(AnAction action) {
            this.myAction = action;
        }

        public AnAction createAction(JComponent component) {
            return this.myAction;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CopyActionDescription
    extends CustomActionDescription<T> {
        private final Convertor<T, T> myCopier;
        private final Condition<T> myEnabled;
        private final String myActionName;
        private boolean myVisibleWhenDisabled;

        public CopyActionDescription(String actionName, Convertor<T, T> copier, Condition<T> enableCondition) {
            this.myActionName = actionName;
            this.myCopier = copier;
            this.myEnabled = enableCondition;
            this.myVisibleWhenDisabled = true;
        }

        @Override
        public CustomActionDescription.BaseAction createAction(JComponent component) {
            ActionBehaviour behaviour = new ActionBehaviour<T>(){

                @Override
                public T performAction(AnActionEvent e) {
                    Object newElement = CopyActionDescription.this.myCopier.convert(ReorderableListController.this.myList.getSelectedValue());
                    ReorderableListController.this.handleNewElement(newElement);
                    return newElement;
                }

                @Override
                public void updateAction(AnActionEvent e) {
                    boolean applicable = ReorderableListController.this.myList.getSelectedIndices().length == 1;
                    Presentation presentation = e.getPresentation();
                    if (!applicable) {
                        presentation.setEnabled(applicable);
                        return;
                    }
                    boolean enabled = CopyActionDescription.this.myEnabled.value(ReorderableListController.this.myList.getSelectedValue());
                    presentation.setEnabled(enabled);
                    presentation.setVisible(enabled || CopyActionDescription.this.myVisibleWhenDisabled);
                }
            };
            return this.createAction(behaviour);
        }

        @Override
        public Icon getActionIcon() {
            return COPY_ICON;
        }

        @Override
        public String getActionName() {
            return this.myActionName;
        }

        public void setVisibleWhenDisabled(boolean visible) {
            this.myVisibleWhenDisabled = visible;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AddActionDescription
    extends CustomActionDescription<T> {
        private final String myActionDescription;
        private final Factory<T> myAddHandler;
        private final boolean myCreateShortcut;
        private Icon myIcon = IconLoader.getIcon("/general/add.png");

        public AddActionDescription(String actionDescription, Factory<T> addHandler, boolean createShortcut) {
            this.myActionDescription = actionDescription;
            this.myAddHandler = addHandler;
            this.myCreateShortcut = createShortcut;
        }

        @Override
        public CustomActionDescription.BaseAction createAction(JComponent component) {
            ActionBehaviour behaviour = new ActionBehaviour<T>(){

                @Override
                public T performAction(AnActionEvent e) {
                    Object newElement = AddActionDescription.this.myAddHandler.create();
                    if (newElement == null) {
                        return null;
                    }
                    ReorderableListController.this.handleNewElement(newElement);
                    return newElement;
                }

                @Override
                public void updateAction(AnActionEvent e) {
                }
            };
            CustomActionDescription.BaseAction action = this.createAction(behaviour);
            if (this.myCreateShortcut) {
                action.registerCustomShortcutSet(CommonShortcuts.INSERT, component);
            }
            return action;
        }

        @Override
        public Icon getActionIcon() {
            return this.myIcon;
        }

        @Override
        public String getActionName() {
            return this.myActionDescription;
        }

        public void setIcon(Icon icon) {
            this.myIcon = icon;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RemoveActionDescription
    extends CustomActionDescription<List<T>> {
        private final String myActionName;
        private Condition<List<T>> myConfirmation;
        private Condition<T> myEnableCondition;

        public RemoveActionDescription(String actionName) {
            this.myActionName = actionName;
        }

        @Override
        public CustomActionDescription.BaseAction createAction(JComponent component) {
            ActionBehaviour behaviour = new ActionBehaviour<List<T>>(){

                @Override
                public List<T> performAction(AnActionEvent e) {
                    if (RemoveActionDescription.this.myConfirmation != null && !RemoveActionDescription.this.myConfirmation.value(Arrays.asList(ReorderableListController.this.myList.getSelectedValues()))) {
                        return Collections.emptyList();
                    }
                    return ListUtil.removeSelectedItems(ReorderableListController.this.myList, RemoveActionDescription.this.myEnableCondition);
                }

                @Override
                public void updateAction(AnActionEvent e) {
                    e.getPresentation().setEnabled(ListUtil.canRemoveSelectedItems(ReorderableListController.this.myList, RemoveActionDescription.this.myEnableCondition));
                }
            };
            CustomActionDescription.BaseAction action = this.createAction(behaviour);
            action.registerCustomShortcutSet(CommonShortcuts.DELETE, component);
            return action;
        }

        @Override
        protected Icon getActionIcon() {
            return REMOVE_ICON;
        }

        @Override
        protected String getActionName() {
            return this.myActionName;
        }

        public void setConfirmation(Condition<List<T>> confirmation) {
            this.myConfirmation = confirmation;
        }

        public void setEnableCondition(Condition<T> enableCondition) {
            this.myEnableCondition = enableCondition;
        }

        public JList getList() {
            return ReorderableListController.this.myList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ActionBehaviour<T> {
        public T performAction(AnActionEvent var1);

        public void updateAction(AnActionEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CustomActionDescription<V>
    extends ActionDescription {
        private final ArrayList<ActionNotification<V>> myPostHandlers = new ArrayList(1);
        private boolean myShowText = false;

        public void addPostHandler(ActionNotification<V> runnable) {
            this.myPostHandlers.add(runnable);
        }

        protected void runPostHandlers(V change) {
            for (ActionNotification<V> runnable : this.myPostHandlers) {
                runnable.afterActionPerformed(change);
            }
        }

        @Override
        public abstract BaseAction createAction(JComponent var1);

        BaseAction createAction(ActionBehaviour behaviour) {
            return this.myShowText ? new ActionWithText(this, this.getActionName(), null, this.getActionIcon(), behaviour) : new BaseAction(this, this.getActionName(), null, this.getActionIcon(), behaviour);
        }

        protected abstract Icon getActionIcon();

        protected abstract String getActionName();

        public void setShowText(boolean showText) {
            this.myShowText = showText;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ActionWithText<V>
        extends BaseAction {
            public ActionWithText(CustomActionDescription<V> customActionDescription, String text, String description, Icon icon, ActionBehaviour<V> behaviour) {
                super(customActionDescription, text, description, icon, behaviour);
            }

            @Override
            public boolean displayTextInToolbar() {
                return true;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class BaseAction<V>
        extends AnAction {
            private final ActionBehaviour<V> myBehaviour;
            private CustomActionDescription<V> myCustomActionDescription;

            public BaseAction(CustomActionDescription<V> customActionDescription, String text, String description, Icon icon, ActionBehaviour<V> behaviour) {
                super(text, description, icon);
                this.myBehaviour = behaviour;
                this.myCustomActionDescription = customActionDescription;
            }

            @Override
            public void actionPerformed(AnActionEvent e) {
                V change = this.myBehaviour.performAction(e);
                if (change == null) {
                    return;
                }
                this.myCustomActionDescription.runPostHandlers(change);
            }

            @Override
            public void update(AnActionEvent e) {
                this.myBehaviour.updateAction(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ActionNotification<T> {
        public void afterActionPerformed(T var1);
    }

    protected static abstract class ActionDescription {
        protected ActionDescription() {
        }

        public abstract AnAction createAction(JComponent var1);
    }
}

