/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.CaptionPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public interface PopupBorder
extends Border {
    public void setActive(boolean var1);

    public static class BaseBorder
    implements PopupBorder {
        private boolean myVisible;
        private Color myActiveColor;
        private Color myPassiveColor;
        private boolean myActive;

        protected BaseBorder() {
            this(false, null, null);
        }

        protected BaseBorder(boolean visible, Color activeColor, Color passiveColor) {
            this.myVisible = visible;
            this.myActiveColor = activeColor;
            this.myPassiveColor = passiveColor;
        }

        public void setActive(boolean active) {
            this.myActive = active;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!this.myVisible) {
                return;
            }
            Color color = this.myActive ? this.myActiveColor : this.myPassiveColor;
            g.setColor(color);
            g.drawRect(x, y, width - 1, height - 1);
        }

        public Insets getBorderInsets(Component c) {
            return this.myVisible ? new Insets(1, 1, 1, 1) : new Insets(0, 0, 0, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class Factory {
        private Factory() {
        }

        public static PopupBorder create(boolean active) {
            BaseBorder border = SystemInfo.isMac ? new BaseBorder() : new BaseBorder(true, CaptionPanel.getBorderColor(true), CaptionPanel.getBorderColor(false));
            border.setActive(active);
            return border;
        }
    }
}

