/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.IdeBorderFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OptionGroup {
    private String myTitle;
    private List myOptions;
    private List myIsShifted;

    public OptionGroup(String title) {
        this.myTitle = title;
        this.myOptions = new ArrayList();
        this.myIsShifted = new ArrayList();
    }

    public OptionGroup() {
        this(null);
    }

    public void add(JComponent component) {
        this.add(component, false);
    }

    public void add(JComponent component, boolean indented) {
        this.myOptions.add(component);
        this.myIsShifted.add(indented);
    }

    public void add(JComponent leftComponent, JComponent rightComponent) {
        this.add(leftComponent, rightComponent, false);
    }

    public void add(JComponent leftComponent, JComponent rightComponent, boolean indented) {
        this.myOptions.add(new Pair<JComponent, JComponent>(leftComponent, rightComponent));
        this.myIsShifted.add(indented);
    }

    public JPanel createPanel() {
        JPanel panel = new JPanel();
        if (this.myTitle != null) {
            panel.setBorder(IdeBorderFactory.createTitledBorder(this.myTitle));
        }
        panel.setLayout(new GridBagLayout());
        for (int i = 0; i < this.myOptions.size(); ++i) {
            Object option;
            int leftInset;
            boolean weighty = false;
            int n = leftInset = Boolean.TRUE.equals(this.myIsShifted.get(i)) ? 15 : 5;
            if (this.myTitle == null) {
                leftInset -= 4;
            }
            if ((option = this.myOptions.get(i)) instanceof JComponent) {
                JComponent component = (JComponent)option;
                int verticalInset = component instanceof JLabel || component instanceof JTextField ? 2 : 0;
                panel.add((Component)component, new GridBagConstraints(0, i, 2, 1, 1.0, (double)weighty, 18, OptionGroup.getFill(component), new Insets(verticalInset, leftInset, verticalInset, 5), 0, 0));
                continue;
            }
            Pair pair = (Pair)option;
            JComponent firstComponent = (JComponent)pair.first;
            int verticalInset = firstComponent instanceof JLabel || firstComponent instanceof JTextField ? 2 : 0;
            panel.add((Component)firstComponent, new GridBagConstraints(0, i, 1, 1, 1.0, (double)weighty, 17, OptionGroup.getFill(firstComponent), new Insets(verticalInset, leftInset, verticalInset, 5), 0, 0));
            JComponent secondComponent = (JComponent)pair.second;
            verticalInset = secondComponent instanceof JLabel || secondComponent instanceof JTextField ? 2 : 0;
            panel.add((Component)secondComponent, new GridBagConstraints(1, i, 1, 1, 0.0, (double)weighty, 13, 2, new Insets(verticalInset, 5, verticalInset, 5), 0, 0));
        }
        JPanel p = new JPanel();
        p.setPreferredSize(new Dimension(0, 0));
        panel.add((Component)p, new GridBagConstraints(0, this.myOptions.size(), 2, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private static int getFill(JComponent component) {
        if (component instanceof JCheckBox) {
            return 0;
        }
        return 2;
    }

    public JComponent[] getComponents() {
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        for (int i = 0; i < this.myOptions.size(); ++i) {
            Object o = this.myOptions.get(i);
            if (o instanceof Pair) {
                components.add((JComponent)((Pair)o).first);
                components.add((JComponent)((Pair)o).second);
                continue;
            }
            components.add((JComponent)o);
        }
        return components.toArray(new JComponent[components.size()]);
    }
}

