/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NonNls;

public class ListScrollingUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ui.ListScrollingUtil");
    @NonNls
    protected static final String SCROLLUP_ACTION_ID = "scrollUp";
    @NonNls
    protected static final String SCROLLDOWN_ACTION_ID = "scrollDown";
    @NonNls
    protected static final String SELECT_PREVIOUS_ROW_ACTION_ID = "selectPreviousRow";
    @NonNls
    protected static final String SELECT_NEXT_ROW_ACTION_ID = "selectNextRow";
    @NonNls
    protected static final String SELECT_LAST_ROW_ACTION_ID = "selectLastRow";
    @NonNls
    protected static final String SELECT_FIRST_ROW_ACTION_ID = "selectFirstRow";
    public static final int ROW_PADDING = 2;

    public static void selectItem(JList list, int index) {
        LOG.assertTrue(index >= 0);
        LOG.assertTrue(index < list.getModel().getSize());
        ListScrollingUtil.ensureIndexIsVisible(list, index, 0);
        list.setSelectedIndex(index);
    }

    public static void ensureSelectionExists(JList list) {
        int size = list.getModel().getSize();
        if (size == 0) {
            list.clearSelection();
            return;
        }
        int selectedIndex = list.getSelectedIndex();
        if (selectedIndex < 0 || selectedIndex >= size) {
            selectedIndex = 0;
        }
        ListScrollingUtil.selectItem(list, selectedIndex);
    }

    public static boolean selectItem(JList list, Object item) {
        ListModel model = list.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            Object anItem = model.getElementAt(i);
            if (!item.equals(anItem)) continue;
            ListScrollingUtil.selectItem(list, i);
            return true;
        }
        return false;
    }

    public static void movePageUp(JList list) {
        Rectangle cellBounds;
        int bottom;
        int visible = ListScrollingUtil.getVisibleRowCount(list);
        if (visible <= 0) {
            ListScrollingUtil.moveHome(list);
            return;
        }
        int size = list.getModel().getSize();
        int decrement = visible - 1;
        int index = Math.max(list.getSelectedIndex() - decrement, 0);
        int top = list.getFirstVisibleIndex() - decrement;
        if (top < 0) {
            top = 0;
        }
        if ((bottom = top + visible - 1) >= size) {
            bottom = size - 1;
        }
        if ((cellBounds = list.getCellBounds(top, bottom)) == null) {
            ListScrollingUtil.moveHome(list);
            return;
        }
        list.scrollRectToVisible(cellBounds);
        list.setSelectedIndex(index);
        list.ensureIndexIsVisible(index);
    }

    public static void movePageDown(JList list) {
        Rectangle cellBounds;
        int visible = ListScrollingUtil.getVisibleRowCount(list);
        if (visible <= 0) {
            ListScrollingUtil.moveEnd(list);
            return;
        }
        int size = list.getModel().getSize();
        int increment = visible - 1;
        int index = Math.min(list.getSelectedIndex() + increment, size - 1);
        int top = list.getFirstVisibleIndex() + increment;
        int bottom = top + visible - 1;
        if (bottom >= size) {
            bottom = size - 1;
        }
        if ((cellBounds = list.getCellBounds(top, bottom)) == null) {
            ListScrollingUtil.moveEnd(list);
            return;
        }
        list.scrollRectToVisible(cellBounds);
        list.setSelectedIndex(index);
        list.ensureIndexIsVisible(index);
    }

    public static void moveHome(JList list) {
        list.setSelectedIndex(0);
        list.ensureIndexIsVisible(0);
    }

    public static void moveEnd(JList list) {
        int index = list.getModel().getSize() - 1;
        list.setSelectedIndex(index);
        list.ensureIndexIsVisible(index);
    }

    public static void ensureIndexIsVisible(JList list, int index, int moveDirection) {
        Rectangle cellBounds;
        int bottom;
        int top;
        int visible = ListScrollingUtil.getVisibleRowCount(list);
        int size = list.getModel().getSize();
        if (moveDirection == 0) {
            top = index - (visible - 1) / 2;
            bottom = top + visible - 1;
        } else if (moveDirection < 0) {
            top = index - 2;
            bottom = index;
        } else {
            top = index;
            bottom = index + 2;
        }
        if (top < 0) {
            top = 0;
        }
        if (bottom >= size) {
            bottom = size - 1;
        }
        if ((cellBounds = list.getCellBounds(top, bottom)) != null) {
            list.scrollRectToVisible(cellBounds);
        }
    }

    private static int getVisibleRowCount(JList list) {
        return list.getLastVisibleIndex() - list.getFirstVisibleIndex() + 1;
    }

    public static void moveDown(JList list, int modifiers) {
        int indexToSelect;
        int size = list.getModel().getSize();
        if (size == 0) {
            return;
        }
        ListSelectionModel selectionModel = list.getSelectionModel();
        int index = selectionModel.getLeadSelectionIndex();
        boolean cycleScrolling = UISettings.getInstance().CYCLE_SCROLLING;
        if (index < size - 1) {
            indexToSelect = index + 1;
        } else if (cycleScrolling && index == size - 1) {
            indexToSelect = 0;
        } else {
            return;
        }
        ListScrollingUtil.ensureIndexIsVisible(list, indexToSelect, 1);
        if (selectionModel.getSelectionMode() == 0) {
            list.setSelectedIndex(indexToSelect);
        } else {
            if ((modifiers & 0x40) == 0) {
                selectionModel.removeSelectionInterval(selectionModel.getMinSelectionIndex(), selectionModel.getMaxSelectionIndex());
            }
            selectionModel.addSelectionInterval(indexToSelect, indexToSelect);
        }
    }

    public static void moveUp(JList list, int modifiers) {
        int indexToSelect;
        int size = list.getModel().getSize();
        int index = list.getSelectedIndex();
        boolean cycleScrolling = UISettings.getInstance().CYCLE_SCROLLING;
        if (index > 0) {
            indexToSelect = index - 1;
        } else if (cycleScrolling && index == 0) {
            indexToSelect = size - 1;
        } else {
            return;
        }
        ListScrollingUtil.ensureIndexIsVisible(list, indexToSelect, -1);
        if (list.getSelectionMode() == 0) {
            list.setSelectedIndex(indexToSelect);
        } else {
            ListSelectionModel selectionModel = list.getSelectionModel();
            if ((modifiers & 0x40) == 0) {
                selectionModel.removeSelectionInterval(selectionModel.getMinSelectionIndex(), selectionModel.getMaxSelectionIndex());
            }
            selectionModel.addSelectionInterval(indexToSelect, indexToSelect);
        }
    }

    public static void installActions(final JList list) {
        list.getActionMap().put(SCROLLUP_ACTION_ID, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ListScrollingUtil.movePageUp(list);
            }
        });
        list.getActionMap().put(SCROLLDOWN_ACTION_ID, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ListScrollingUtil.movePageDown(list);
            }
        });
        list.getActionMap().put(SELECT_PREVIOUS_ROW_ACTION_ID, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ListScrollingUtil.moveUp(list, e.getModifiers());
            }
        });
        list.getActionMap().put(SELECT_NEXT_ROW_ACTION_ID, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ListScrollingUtil.moveDown(list, e.getModifiers());
            }
        });
        list.getActionMap().put(SELECT_LAST_ROW_ACTION_ID, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ListScrollingUtil.moveEnd(list);
            }
        });
        list.getActionMap().put(SELECT_FIRST_ROW_ACTION_ID, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ListScrollingUtil.moveHome(list);
            }
        });
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ListScrollingUtil.moveHome(list);
            }
        }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(37, 0)), list);
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ListScrollingUtil.moveEnd(list);
            }
        }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(39, 0)), list);
    }
}

