/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringListModel<T>
extends AbstractListModel {
    private final ListModel myOriginalModel;
    private Condition<T> myCondition = null;
    private final ListDataListener myListDataListener = new ListDataListener(){

        public void contentsChanged(ListDataEvent e) {
            int[] interval = FilteringListModel.this.findFilteredInterval(e);
            FilteringListModel.this.fireContentsChanged(this, FilteringListModel.this.filteredIndex(interval[0]), FilteringListModel.this.filteredIndex(interval[1]));
        }

        public void intervalAdded(ListDataEvent e) {
            int[] interval = FilteringListModel.this.findFilteredInterval(e);
            FilteringListModel.this.fireIntervalAdded(this, interval[0], interval[1]);
        }

        public void intervalRemoved(ListDataEvent e) {
            int[] interval = FilteringListModel.this.findFilteredInterval(e);
            FilteringListModel.this.fireIntervalRemoved(this, interval[0], interval[1]);
        }
    };

    public FilteringListModel(ListModel originalModel) {
        this.myOriginalModel = originalModel;
        this.myOriginalModel.addListDataListener(this.myListDataListener);
    }

    public void dispose() {
        this.myOriginalModel.removeListDataListener(this.myListDataListener);
    }

    public void setFilter(Condition<T> condition) {
        int prevSize = this.getSize();
        this.myCondition = condition;
        int newSize = this.getSize();
        this.fireContentsChanged(this, 0, Math.min(prevSize, newSize) - 1);
        if (newSize > prevSize) {
            this.fireIntervalAdded(this, prevSize, newSize - 1);
        } else if (newSize < prevSize) {
            this.fireIntervalRemoved(this, newSize, prevSize - 1);
        }
    }

    private int[] findFilteredInterval(ListDataEvent e) {
        return this.findFilteredInterval(e.getIndex0(), e.getIndex1());
    }

    @Override
    public int getSize() {
        return this.getItems().size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.getItems().get(index);
    }

    private List<T> getItems() {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < this.myOriginalModel.getSize(); ++i) {
            T element = this.getOriginalElementAt(i);
            if (!this.passElement(element)) continue;
            list.add(element);
        }
        return list;
    }

    private T getOriginalElementAt(int i) {
        return (T)this.myOriginalModel.getElementAt(i);
    }

    private boolean passElement(T element) {
        return this.myCondition == null || this.myCondition.value(element);
    }

    private int findFirst(int fromIndex, int toIndex) {
        for (int i = fromIndex; i <= toIndex; ++i) {
            if (!this.passElement(this.getOriginalElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    private int findLast(int fromIndex, int toIndex) {
        for (int i = toIndex; i >= fromIndex; --i) {
            if (!this.passElement(this.getOriginalElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    private int filteredIndex(int index) {
        return this.getItems().indexOf(this.getOriginalElementAt(index));
    }

    private int[] findFilteredInterval(int index0, int index1) {
        int[] interval = new int[2];
        interval[0] = this.findFirst(index0, index1);
        if (interval[0] == -1) {
            return null;
        }
        interval[1] = this.findLast(interval[0], index1);
        return interval;
    }

    private int getOriginalIndexOf(T item) {
        for (int i = 0; i < this.myOriginalModel.getSize(); ++i) {
            if (!Comparing.equal(item, this.myOriginalModel.getElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int findNearestIndex(T item) {
        int index = this.getItems().indexOf(item);
        if (index != -1) {
            return index;
        }
        int originalIndex = this.getOriginalIndexOf(item);
        if (originalIndex == -1) {
            return -1;
        }
        index = this.findFirst(originalIndex, this.myOriginalModel.getSize() - 1);
        if (index != -1) {
            return this.filteredIndex(index);
        }
        index = this.findLast(0, originalIndex);
        if (index != -1) {
            return this.filteredIndex(index);
        }
        return -1;
    }
}

