/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ModalityState;
import com.intellij.ui.SearchTextFieldWithStoredHistory;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;

public abstract class FilterComponent
extends JPanel {
    private final SearchTextFieldWithStoredHistory myFilter;
    private final Alarm myUpdateAlarm = new Alarm();

    public FilterComponent(@NonNls String propertyName, int historySize) {
        super(new BorderLayout());
        this.myFilter = new SearchTextFieldWithStoredHistory(propertyName);
        this.myFilter.getTextEditor().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    FilterComponent.this.myFilter.addCurrentTextToHistory();
                    FilterComponent.this.filter();
                }
            }
        });
        this.myFilter.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.onChange();
            }

            public void removeUpdate(DocumentEvent e) {
                this.onChange();
            }

            public void changedUpdate(DocumentEvent e) {
                this.onChange();
            }

            public void onChange() {
                FilterComponent.this.myUpdateAlarm.cancelAllRequests();
                FilterComponent.this.myUpdateAlarm.addRequest(new Runnable(){

                    public void run() {
                        FilterComponent.this.onlineFilter();
                    }
                }, 100, ModalityState.stateForComponent(FilterComponent.this.myFilter));
            }
        });
        this.myFilter.setHistorySize(historySize);
        this.add((Component)this.myFilter, "Center");
    }

    public void setHistorySize(int historySize) {
        this.myFilter.setHistorySize(historySize);
    }

    public void reset() {
        this.myFilter.reset();
    }

    public String getFilter() {
        return this.myFilter.getText();
    }

    public void setSelectedItem(String filter) {
        this.myFilter.setSelectedItem(filter);
    }

    public void setFilter(String filter) {
        this.myFilter.setText(filter);
    }

    public void selectText() {
        this.myFilter.selectText();
    }

    public boolean requestFocusInWindow() {
        return this.myFilter.requestFocusInWindow();
    }

    public abstract void filter();

    protected void onlineFilter() {
        this.filter();
    }

    public void dispose() {
        this.myUpdateAlarm.cancelAllRequests();
    }
}

