/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class EdgeBorder
implements Border {
    public static final int EDGE_RIGHT = 61440;
    public static final int EDGE_BOTTOM = 3840;
    public static final int EDGE_LEFT = 240;
    public static final int EDGE_TOP = 15;
    public static final int EDGE_ALL = 65535;
    private Insets myInsets = new Insets(2, 2, 2, 2);
    private int b;

    public EdgeBorder(int i) {
        this.b = i;
        this.recalcInsets();
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public Insets getBorderInsets(Component component) {
        return this.myInsets;
    }

    public void paintBorder(Component component, Graphics g, int x, int y, int width, int height) {
        Color color = UIUtil.getSeparatorShadow();
        Color color1 = UIUtil.getSeparatorHighlight();
        Color color2 = g.getColor();
        if ((this.b & 0xF) != 0) {
            g.setColor(color);
            UIUtil.drawLine(g, x, y, x + width - 1, y);
            g.setColor(color1);
            UIUtil.drawLine(g, x, y + 1, x + width - 1, y + 1);
        }
        if ((this.b & 0xF0) != 0) {
            g.setColor(color);
            UIUtil.drawLine(g, x, y, x, y + height - 1);
            g.setColor(color1);
            UIUtil.drawLine(g, x + 1, y, x + 1, y + height - 1);
        }
        if ((this.b & 0xF00) != 0) {
            g.setColor(color);
            UIUtil.drawLine(g, x, y + height - 2, x + width - 1, y + height - 2);
            g.setColor(color1);
            UIUtil.drawLine(g, x, y + height - 1, x + width - 1, y + height - 1);
        }
        if ((this.b & 0xF000) != 0) {
            g.setColor(color1);
            UIUtil.drawLine(g, x + width + 1, y, x + width + 1, y + height - 1);
            g.setColor(color);
            UIUtil.drawLine(g, x + width, y, x + width, y + height - 1);
        }
        g.setColor(color2);
    }

    protected void recalcInsets() {
        this.myInsets.top = (this.b & 0xF) == 0 ? 0 : 2;
        this.myInsets.left = (this.b & 0xF0) == 0 ? 0 : 2;
        this.myInsets.bottom = (this.b & 0xF00) == 0 ? 0 : 2;
        this.myInsets.right = (this.b & 0xF000) == 0 ? 0 : 2;
    }
}

