/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.util.ui.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckboxTreeBase
extends Tree {
    public CheckboxTreeBase(final CheckboxTreeCellRendererBase cellRenderer, CheckedTreeNode root) {
        this.setCellRenderer(cellRenderer);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setLineStyleAngled();
        TreeUtil.installActions(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int row = CheckboxTreeBase.this.getRowForLocation(e.getX(), e.getY());
                if (row >= 0) {
                    Rectangle rowBounds = CheckboxTreeBase.this.getRowBounds(row);
                    cellRenderer.setBounds(rowBounds);
                    Rectangle checkBounds = cellRenderer.myCheckbox.getBounds();
                    checkBounds.setLocation(rowBounds.getLocation());
                    CheckedTreeNode node = (CheckedTreeNode)CheckboxTreeBase.this.getPathForRow(row).getLastPathComponent();
                    if (checkBounds.contains(e.getPoint())) {
                        if (node.isEnabled()) {
                            CheckboxTreeBase.this.toggleNode(node);
                            CheckboxTreeBase.this.setSelectionRow(row);
                        }
                        e.consume();
                    } else if (e.getClickCount() > 1) {
                        CheckboxTreeBase.this.onDoubleClick(node);
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (CheckboxTreeBase.this.isToggleEvent(e)) {
                    TreePath treePath = CheckboxTreeBase.this.getLeadSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    CheckedTreeNode firstNode = (CheckedTreeNode)treePath.getLastPathComponent();
                    boolean checked = CheckboxTreeBase.this.toggleNode(firstNode);
                    TreePath[] selectionPaths = CheckboxTreeBase.this.getSelectionPaths();
                    for (int i = 0; selectionPaths != null && i < selectionPaths.length; ++i) {
                        TreePath selectionPath = selectionPaths[i];
                        CheckedTreeNode node = (CheckedTreeNode)selectionPath.getLastPathComponent();
                        CheckboxTreeBase.this.checkNode(node, checked);
                    }
                    e.consume();
                }
            }
        });
        this.setSelectionRow(0);
        this.setModel(new DefaultTreeModel(root));
    }

    protected void onDoubleClick(CheckedTreeNode node) {
    }

    protected boolean isToggleEvent(KeyEvent e) {
        return e.getKeyCode() == 32;
    }

    protected boolean toggleNode(CheckedTreeNode node) {
        boolean checked = !node.isChecked();
        this.checkNode(node, checked);
        TreeModel model = this.getModel();
        model.valueForPathChanged(new TreePath(node.getPath()), node.getUserObject());
        return checked;
    }

    public int getToggleClickCount() {
        return -1;
    }

    protected void checkNode(CheckedTreeNode node, boolean checked) {
        node.setChecked(checked);
        this.repaint();
    }

    protected void adjustParentsAndChildren(CheckedTreeNode node, boolean checked) {
        node.setChecked(checked);
        if (checked) {
            for (CheckedTreeNode parent = (CheckedTreeNode)node.getParent(); parent != null; parent = (CheckedTreeNode)parent.getParent()) {
                parent.setChecked(true);
            }
        } else {
            CheckboxTreeBase.uncheckChildren(node);
        }
        this.repaint();
    }

    private static void uncheckChildren(CheckedTreeNode node) {
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            CheckedTreeNode child = (CheckedTreeNode)children.nextElement();
            child.setChecked(false);
            CheckboxTreeBase.uncheckChildren(child);
        }
    }

    public static abstract class CheckboxTreeCellRendererBase
    extends JPanel
    implements TreeCellRenderer {
        private final ColoredTreeCellRenderer myTextRenderer;
        public final JCheckBox myCheckbox = new JCheckBox();

        public CheckboxTreeCellRendererBase(boolean opaque) {
            super(new BorderLayout());
            this.myTextRenderer = new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                }
            };
            this.myTextRenderer.setOpaque(opaque);
            this.add((Component)this.myCheckbox, "West");
            this.add((Component)this.myTextRenderer, "Center");
        }

        public CheckboxTreeCellRendererBase() {
            this(true);
        }

        public final Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.invalidate();
            if (value instanceof CheckedTreeNode) {
                CheckedTreeNode node = (CheckedTreeNode)value;
                this.myCheckbox.setEnabled(node.isEnabled());
                this.myCheckbox.setSelected(node.isChecked());
                this.myCheckbox.setBackground(null);
                this.setBackground(null);
                this.myTextRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                this.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
            }
            return this;
        }

        public abstract void customizeCellRenderer(JTree var1, Object var2, boolean var3, boolean var4, boolean var5, int var6, boolean var7);

        public ColoredTreeCellRenderer getTextRenderer() {
            return this.myTextRenderer;
        }

        public JCheckBox getCheckbox() {
            return this.myCheckbox;
        }
    }
}

