/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ActiveComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class CaptionPanel
extends JPanel {
    private static final Color CNT_COLOR = new Color(240, 240, 240);
    private static final Color BND_COLOR = new Color(240, 240, 240);
    public static final Color CNT_ACTIVE_COLOR = new Color(0xCACACA);
    public static final Color BND_ACTIVE_COLOR = new Color(0xEFEFEF);
    private boolean myActive = false;
    private ActiveComponent myButtonComponent;

    public CaptionPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 4, 0, 4));
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.myActive) {
            g.setColor(Color.white);
            g.drawLine(0, 0, this.getWidth(), 0);
            g.setColor(Color.gray);
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, BND_ACTIVE_COLOR, 0.0f, this.getHeight(), CNT_ACTIVE_COLOR));
        } else {
            g.setColor(Color.white);
            g.drawLine(0, 0, this.getWidth(), 0);
            g.setColor(Color.lightGray);
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, BND_COLOR, 0.0f, this.getHeight(), CNT_COLOR));
        }
        g2d.fillRect(0, 1, this.getWidth(), this.getHeight() - 2);
    }

    public void setActive(boolean active) {
        this.myActive = active;
        if (this.myButtonComponent != null) {
            this.myButtonComponent.setActive(active);
        }
        this.repaint();
    }

    public void setButtonComponent(ActiveComponent component) {
        if (this.myButtonComponent != null) {
            this.remove(this.myButtonComponent.getComponent());
        }
        this.add((Component)component.getComponent(), "East");
        this.myButtonComponent = component;
    }

    public boolean isWithinPanel(MouseEvent e) {
        Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), this);
        Component c = this.findComponentAt(p);
        return c != null && c != this.myButtonComponent;
    }

    public static Color getBorderColor(boolean isActive) {
        return isActive ? Color.gray : Color.lightGray;
    }
}

