/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.UIBundle;
import com.intellij.util.Alarm;
import com.intellij.util.OpenSourceUtil;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public abstract class AutoScrollToSourceHandler {
    private Alarm myAutoScrollAlarm;

    protected AutoScrollToSourceHandler() {
    }

    public void install(final JTree tree) {
        this.myAutoScrollAlarm = new Alarm();
        tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    return;
                }
                TreePath location = tree.getPathForLocation(e.getPoint().x, e.getPoint().y);
                if (location != null) {
                    AutoScrollToSourceHandler.this.onMouseClicked(tree);
                }
            }
        });
        tree.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                AutoScrollToSourceHandler.this.onSelectionChanged(tree);
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                AutoScrollToSourceHandler.this.onSelectionChanged(tree);
            }
        });
    }

    public void install(final JList jList) {
        this.myAutoScrollAlarm = new Alarm();
        jList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    return;
                }
                Object source = e.getSource();
                int index = jList.locationToIndex(SwingUtilities.convertPoint(source instanceof Component ? (Component)source : null, e.getPoint(), jList));
                if (index >= 0 && index < jList.getModel().getSize()) {
                    AutoScrollToSourceHandler.this.onMouseClicked(jList);
                }
            }
        });
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AutoScrollToSourceHandler.this.onSelectionChanged(jList);
            }
        });
    }

    public void cancelAllRequests() {
        if (this.myAutoScrollAlarm != null) {
            this.myAutoScrollAlarm.cancelAllRequests();
        }
    }

    public void onMouseClicked(final Component component) {
        this.myAutoScrollAlarm.cancelAllRequests();
        if (this.isAutoScrollMode()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                public void run() {
                    AutoScrollToSourceHandler.this.scrollToSource(component);
                }
            });
        }
    }

    private void onSelectionChanged(final Component component) {
        if (!this.isAutoScrollMode()) {
            return;
        }
        if (this.needToCheckFocus() && !component.hasFocus()) {
            return;
        }
        this.myAutoScrollAlarm.cancelAllRequests();
        this.myAutoScrollAlarm.addRequest(new Runnable(){

            public void run() {
                AutoScrollToSourceHandler.this.scrollToSource(component);
            }
        }, 500);
    }

    protected boolean needToCheckFocus() {
        return true;
    }

    protected abstract boolean isAutoScrollMode();

    protected abstract void setAutoScrollMode(boolean var1);

    protected void scrollToSource(Component tree) {
        DataContext dataContext = DataManager.getInstance().getDataContext(tree);
        VirtualFile vFile = DataKeys.VIRTUAL_FILE.getData(dataContext);
        if (vFile != null && FileTypeManager.getInstance().getFileTypeByFile(vFile) == StdFileTypes.UNKNOWN) {
            return;
        }
        Navigatable[] navigatables = (Navigatable[])dataContext.getData("NavigatableArray");
        if (navigatables != null) {
            for (Navigatable navigatable : navigatables) {
                if (navigatable.canNavigateToSource()) continue;
                return;
            }
        }
        OpenSourceUtil.openSourcesFrom(dataContext, false);
    }

    public ToggleAction createToggleAction() {
        return new ToggleAction(UIBundle.message("autoscroll.to.source.action.name", new Object[0]), UIBundle.message("autoscroll.to.source.action.description", new Object[0]), IconLoader.getIcon("/general/autoscrollToSource.png")){

            public boolean isSelected(AnActionEvent event) {
                return AutoScrollToSourceHandler.this.isAutoScrollMode();
            }

            public void setSelected(AnActionEvent event, boolean flag) {
                AutoScrollToSourceHandler.this.setAutoScrollMode(flag);
            }
        };
    }
}

