/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.CommonBundle;
import com.intellij.ui.ListUtil;
import com.intellij.ui.PanelWithButtons;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AddDeleteListPanel
extends PanelWithButtons {
    private String myTitle;
    protected JButton myAddButton = new JButton(CommonBundle.message("button.add", new Object[0]));
    protected JButton myDeleteButton = new JButton(CommonBundle.message("button.delete", new Object[0]));
    protected DefaultListModel myListModel = new DefaultListModel();
    protected JList myList = new JList(this.myListModel);

    public AddDeleteListPanel(String title, List initialList) {
        this.myTitle = title;
        for (Object o : initialList) {
            if (o == null) continue;
            this.myListModel.addElement(o);
        }
        this.myList.setCellRenderer(this.getListCellRenderer());
        this.myList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AddDeleteListPanel.this.myDeleteButton.setEnabled(ListUtil.canRemoveSelectedItems(AddDeleteListPanel.this.myList));
            }
        });
        this.myAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object itemToAdd = AddDeleteListPanel.this.findItemToAdd();
                if (itemToAdd != null) {
                    AddDeleteListPanel.this.myListModel.addElement(itemToAdd);
                    AddDeleteListPanel.this.myList.setSelectedValue(itemToAdd, true);
                }
            }
        });
        this.myDeleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ListUtil.removeSelectedItems(AddDeleteListPanel.this.myList);
            }
        });
        this.initPanel();
    }

    protected abstract Object findItemToAdd();

    public Object[] getListItems() {
        ArrayList items = new ArrayList();
        for (int i = 0; i < this.myListModel.size(); ++i) {
            items.add(this.myListModel.getElementAt(i));
        }
        return items.toArray();
    }

    protected String getLabelText() {
        return this.myTitle;
    }

    protected JButton[] createButtons() {
        return new JButton[]{this.myAddButton, this.myDeleteButton};
    }

    protected JComponent createMainComponent() {
        if (!this.myListModel.isEmpty()) {
            this.myList.setSelectedIndex(0);
        }
        return ScrollPaneFactory.createScrollPane(this.myList);
    }

    protected ListCellRenderer getListCellRenderer() {
        return new DefaultListCellRenderer();
    }
}

