/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TempDirTextFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private final ArrayList<File> myFilesToDelete = new ArrayList();
    private File myTempDir;

    public VirtualFile copyFile(VirtualFile file) {
        try {
            this.createTempDirectory();
            VirtualFile tempDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myTempDir.getCanonicalPath().replace(File.separatorChar, '/'));
            return VfsUtil.copyFile(this, file, tempDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot copy " + file, e);
        }
    }

    public void copyAll(final String dataDir) {
        this.createTempDirectory();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            public void run() {
                block3: {
                    try {
                        VirtualFile tempDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(TempDirTextFixtureImpl.this.myTempDir.getCanonicalPath().replace(File.separatorChar, '/'));
                        VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                        assert (from != null) : dataDir + " not found";
                        VfsUtil.copyDirectory(null, from, tempDir, null);
                    }
                    catch (IOException e) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError((Object)("Cannot copy " + dataDir + ": " + e));
                    }
                }
            }
        });
    }

    public String getTempDirPath() {
        return this.createTempDirectory().getAbsolutePath();
    }

    @Nullable
    public VirtualFile getFile(final String path) {
        final Ref<Object> result = new Ref<Object>(null);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            public void run() {
                block2: {
                    try {
                        String fullPath = TempDirTextFixtureImpl.this.myTempDir.getCanonicalPath().replace(File.separatorChar, '/') + "/" + path;
                        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
                        result.set(file);
                    }
                    catch (IOException e) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError((Object)("Cannot find " + path + ": " + e));
                    }
                }
            }
        });
        return result.get();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VirtualFile createFile(final String name) {
        final File file = this.createTempDirectory();
        VirtualFile virtualFile = ApplicationManager.getApplication().runWriteAction(new Computable<VirtualFile>(){

            @Override
            public VirtualFile compute() {
                try {
                    File file1 = new File(file, name);
                    file1.createNewFile();
                    return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file1);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/TempDirTextFixtureImpl.createFile must not return null");
        }
        return virtualFile;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createTempDirectory();
    }

    public void tearDown() throws Exception {
        for (File fileToDelete : this.myFilesToDelete) {
            TempDirTextFixtureImpl.delete(fileToDelete);
        }
        super.tearDown();
    }

    protected File createTempDirectory() {
        try {
            if (this.myTempDir == null) {
                this.myTempDir = FileUtil.createTempDirectory("unitTest", null);
                this.myFilesToDelete.add(this.myTempDir);
            }
            return this.myTempDir;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create temp dir", e);
        }
    }

    private static void delete(File file) {
        boolean b;
        if (file.isDirectory()) {
            File[] files;
            for (File fileToDelete : files = file.listFiles()) {
                TempDirTextFixtureImpl.delete(fileToDelete);
            }
        }
        if (!(b = file.delete()) && file.exists()) assert (false) : "Can't delete " + file.getAbsolutePath();
    }
}

