/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.ModuleFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ModuleFixtureBuilderImpl<T extends ModuleFixture>
implements ModuleFixtureBuilder<T> {
    private static int ourIndex;
    private final ModuleType myModuleType;
    protected final List<String> myContentRoots;
    protected final List<String> mySourceRoots;
    protected final TestFixtureBuilder<? extends IdeaProjectTestFixture> myFixtureBuilder;
    private T myModuleFixture;
    private String myOutputPath;

    public ModuleFixtureBuilderImpl(@NotNull ModuleType moduleType, TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        if (moduleType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/ModuleFixtureBuilderImpl.<init> must not be null");
        }
        this.myContentRoots = new ArrayList<String>();
        this.mySourceRoots = new ArrayList<String>();
        this.myModuleType = moduleType;
        this.myFixtureBuilder = fixtureBuilder;
    }

    @Override
    public ModuleFixtureBuilder<T> addContentRoot(String contentRootPath) {
        this.myContentRoots.add(contentRootPath);
        return this;
    }

    @Override
    public ModuleFixtureBuilder<T> addSourceRoot(String sourceRootPath) {
        assert (this.myContentRoots.size() > 0) : "content root should be added first";
        this.mySourceRoots.add(sourceRootPath);
        return this;
    }

    @Override
    public void setOutputPath(String outputPath) {
        this.myOutputPath = outputPath;
    }

    protected Module createModule() {
        Project project = this.myFixtureBuilder.getFixture().getProject();
        assert (project != null);
        return ModuleManager.getInstance(project).newModule(ModuleFixtureBuilderImpl.getNextIndex() + ".iml", this.myModuleType);
    }

    private static int getNextIndex() {
        return ourIndex++;
    }

    @Override
    public synchronized T getFixture() {
        if (this.myModuleFixture == null) {
            this.myModuleFixture = this.instantiateFixture();
        }
        return this.myModuleFixture;
    }

    protected abstract T instantiateFixture();

    Module buildModule() {
        final Module[] module = new Module[]{null};
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            public void run() {
                module[0] = ModuleFixtureBuilderImpl.this.createModule();
                ModuleFixtureBuilderImpl.this.initModule(module[0]);
            }
        });
        return module[0];
    }

    void initModule(Module module) {
        THashSet sourcesLeft = new THashSet();
        ModuleRootManager rootManager = ModuleRootManager.getInstance(module);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        for (String contentRoot : this.myContentRoots) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(contentRoot);
            assert (virtualFile != null) : "cannot find content root: " + contentRoot;
            ContentEntry contentEntry = rootModel.addContentEntry(virtualFile);
            for (String sourceRoot : this.mySourceRoots) {
                VirtualFile file;
                String s = contentRoot + "/" + sourceRoot;
                VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByPath(s);
                if (vf == null && (file = LocalFileSystem.getInstance().refreshAndFindFileByPath(sourceRoot)) != null && VfsUtil.isAncestor(virtualFile, file, false)) {
                    vf = file;
                }
                if (vf == null) continue;
                contentEntry.addSourceFolder(vf, false);
            }
        }
        if (this.myOutputPath != null) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myOutputPath);
            assert (virtualFile != null) : "cannot find output path: " + this.myOutputPath;
            rootModel.setCompilerOutputPath(virtualFile);
        }
        rootModel.commit();
    }
}

