/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.projectRoots.ProjectJdk;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.builders.JavaModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.ModuleFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.ModuleFixtureBuilderImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JavaModuleFixtureBuilderImpl<T extends ModuleFixture>
extends ModuleFixtureBuilderImpl<T>
implements JavaModuleFixtureBuilder<T> {
    private final List<Lib> myLibraries = new ArrayList<Lib>();
    private String myJdk;
    private JavaModuleFixtureBuilder.MockJdkLevel myMockJdkLevel = JavaModuleFixtureBuilder.MockJdkLevel.jdk14;

    public JavaModuleFixtureBuilderImpl(TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        super(ModuleType.JAVA, fixtureBuilder);
    }

    public JavaModuleFixtureBuilderImpl(ModuleType moduleType, TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        super(moduleType, fixtureBuilder);
    }

    @Override
    public JavaModuleFixtureBuilder setLanguageLevel(LanguageLevel languageLevel) {
        throw new UnsupportedOperationException("setLanguageLevel is not implemented in : " + this.getClass());
    }

    @Override
    public JavaModuleFixtureBuilder addLibrary(String libraryName, String ... classPath) {
        HashMap<OrderRootType, String[]> map = new HashMap<OrderRootType, String[]>();
        map.put(OrderRootType.CLASSES, classPath);
        this.myLibraries.add(new Lib(libraryName, map));
        return this;
    }

    @Override
    public JavaModuleFixtureBuilder addLibrary(@NonNls String libraryName, Map<OrderRootType, String[]> roots) {
        this.myLibraries.add(new Lib(libraryName, roots));
        return this;
    }

    @Override
    public JavaModuleFixtureBuilder addLibraryJars(String libraryName, String basePath, String ... jars) {
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        String[] classPath = new String[jars.length];
        for (int i = 0; i < jars.length; ++i) {
            classPath[i] = basePath + jars[i];
        }
        return this.addLibrary(libraryName, classPath);
    }

    @Override
    public JavaModuleFixtureBuilder addJdk(String jdkPath) {
        this.myJdk = jdkPath;
        return this;
    }

    @Override
    public void setMockJdkLevel(JavaModuleFixtureBuilder.MockJdkLevel level) {
        this.myMockJdkLevel = level;
    }

    @Override
    void initModule(Module module) {
        super.initModule(module);
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
        if (this.myMockJdkLevel == JavaModuleFixtureBuilder.MockJdkLevel.jdk15) {
            moduleRootManager.setLanguageLevel(LanguageLevel.JDK_1_5);
        }
        ModifiableRootModel model = moduleRootManager.getModifiableModel();
        LibraryTable libraryTable = model.getModuleLibraryTable();
        for (Lib lib : this.myLibraries) {
            String libraryName = lib.getName();
            Library library = libraryTable.createLibrary(libraryName);
            Library.ModifiableModel libraryModel = library.getModifiableModel();
            for (OrderRootType rootType : OrderRootType.ALL_TYPES) {
                String[] roots;
                for (String root : roots = lib.getRoots(rootType)) {
                    VirtualFile jar;
                    VirtualFile vRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
                    if (vRoot != null && OrderRootType.CLASSES.equals((Object)rootType) && !vRoot.isDirectory() && (jar = JarFileSystem.getInstance().refreshAndFindFileByPath(root + "!/")) != null) {
                        vRoot = jar;
                    }
                    if (vRoot == null) continue;
                    libraryModel.addRoot(vRoot, rootType);
                }
            }
            libraryModel.commit();
            this.libraryCreated(library, module);
        }
        if (this.myJdk != null) {
            model.setJdk(JavaSdkImpl.getInstance().createJdk(module.getName() + "_jdk", this.myJdk, false));
        } else {
            ProjectJdk projectJdk;
            switch (this.myMockJdkLevel) {
                default: {
                    projectJdk = JavaSdkImpl.getMockJdk((String)"java 1.4");
                    break;
                }
                case jdk15: {
                    projectJdk = JavaSdkImpl.getMockJdk15((String)"java 1.5");
                }
            }
            model.setJdk(projectJdk);
        }
        model.commit();
    }

    protected void libraryCreated(Library library, Module module) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Lib {
        private final String myName;
        private final Map<OrderRootType, String[]> myRoots;

        public Lib(String name, Map<OrderRootType, String[]> roots) {
            this.myName = name;
            this.myRoots = roots;
        }

        public String getName() {
            return this.myName;
        }

        public String[] getRoots(OrderRootType rootType) {
            String[] roots = this.myRoots.get((Object)rootType);
            return roots != null ? roots : new String[]{};
        }
    }
}

