/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.testFramework.builders.JavaModuleFixtureBuilder;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.ModuleFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.HeavyIdeaTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.HeavyTestFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.JavaModuleFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.LightIdeaTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.LightTestFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.ModuleFixtureImpl;
import com.intellij.testFramework.fixtures.impl.TempDirTextFixtureImpl;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdeaTestFixtureFactoryImpl
extends IdeaTestFixtureFactory {
    private final Map<Class<? extends ModuleFixtureBuilder>, Class<? extends ModuleFixtureBuilder>> myFixtureBuilderProviders = new HashMap<Class<? extends ModuleFixtureBuilder>, Class<? extends ModuleFixtureBuilder>>();

    public IdeaTestFixtureFactoryImpl() {
        this.registerFixtureBuilder(JavaModuleFixtureBuilder.class, MyJavaModuleFixtureBuilderImpl.class);
    }

    @Override
    public final <T extends ModuleFixtureBuilder> void registerFixtureBuilder(Class<T> aClass, Class<? extends T> implClass) {
        this.myFixtureBuilderProviders.put(aClass, implClass);
    }

    @Override
    public void registerFixtureBuilder(Class<? extends ModuleFixtureBuilder> aClass, String implClassName) {
        try {
            Class<?> implClass = Class.forName(implClassName);
            assert (aClass.isAssignableFrom(implClass));
            this.registerFixtureBuilder(aClass, implClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot instantiate fixture builder implementation", e);
        }
    }

    @Override
    public TestFixtureBuilder<IdeaProjectTestFixture> createLightFixtureBuilder() {
        return new LightTestFixtureBuilderImpl<IdeaProjectTestFixture>(new LightIdeaTestFixtureImpl());
    }

    @Override
    public TestFixtureBuilder<IdeaProjectTestFixture> createFixtureBuilder() {
        return new HeavyTestFixtureBuilderImpl(new HeavyIdeaTestFixtureImpl(), this.myFixtureBuilderProviders);
    }

    @Override
    public CodeInsightTestFixture createCodeInsightFixture(IdeaProjectTestFixture projectFixture) {
        return new CodeInsightTestFixtureImpl(projectFixture);
    }

    @Override
    public TempDirTestFixture createTempDirTestFixture() {
        return new TempDirTextFixtureImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyJavaModuleFixtureBuilderImpl
    extends JavaModuleFixtureBuilderImpl {
        public MyJavaModuleFixtureBuilderImpl(TestFixtureBuilder<? extends IdeaProjectTestFixture> testFixtureBuilder) {
            super(testFixtureBuilder);
        }

        @Override
        protected ModuleFixture instantiateFixture() {
            return new ModuleFixtureImpl(this);
        }
    }
}

