/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.builders.JavaModuleFixtureBuilder;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.HeavyIdeaTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.JavaModuleFixtureBuilderImpl;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.pico.IdeaPicoContainer;
import java.lang.reflect.Field;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HeavyTestFixtureBuilderImpl
implements TestFixtureBuilder<IdeaProjectTestFixture> {
    private final FactoryMap<Class<? extends ModuleFixtureBuilder>, ModuleFixtureBuilder> myModuleFixtureBuilderFactory;
    private HeavyIdeaTestFixtureImpl myFixture;

    public HeavyTestFixtureBuilderImpl(HeavyIdeaTestFixtureImpl fixture, final Map<Class<? extends ModuleFixtureBuilder>, Class<? extends ModuleFixtureBuilder>> providers) {
        this.myFixture = fixture;
        final IdeaPicoContainer container = new IdeaPicoContainer();
        container.registerComponentInstance(this);
        this.myModuleFixtureBuilderFactory = new FactoryMap<Class<? extends ModuleFixtureBuilder>, ModuleFixtureBuilder>(){

            @Override
            protected ModuleFixtureBuilder create(Class<? extends ModuleFixtureBuilder> key) {
                Class implClass = (Class)providers.get(key);
                container.registerComponentImplementation(implClass);
                return (ModuleFixtureBuilder)container.getComponentInstanceOfType(implClass);
            }
        };
    }

    public TestFixtureBuilder<IdeaProjectTestFixture> setModuleType(ModuleType moduleType) {
        new Pair<Class<JavaModuleFixtureBuilder>, Class<JavaModuleFixtureBuilderImpl>>(JavaModuleFixtureBuilder.class, JavaModuleFixtureBuilderImpl.class);
        throw new UnsupportedOperationException("setModuleType is not implemented in : " + this.getClass());
    }

    public TestFixtureBuilder<IdeaProjectTestFixture> setLanguageLevel(LanguageLevel languageLevel) {
        throw new UnsupportedOperationException("setLanguageLevel is not implemented in : " + this.getClass());
    }

    @Override
    public HeavyIdeaTestFixtureImpl getFixture() {
        return this.myFixture;
    }

    @Override
    public <M extends ModuleFixtureBuilder> M addModule(Class<M> builderClass) {
        HeavyTestFixtureBuilderImpl.loadClassConstants(builderClass);
        ModuleFixtureBuilder builder = this.myModuleFixtureBuilderFactory.get(builderClass);
        this.myFixture.addModuleFixtureBuilder(builder);
        return (M)builder;
    }

    private static void loadClassConstants(Class builderClass) {
        try {
            for (Field field : builderClass.getFields()) {
                field.get(null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

