/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class HeavyIdeaTestFixtureImpl
extends BaseFixture
implements IdeaProjectTestFixture {
    @NonNls
    private static final String PROJECT_FILE_PREFIX = "temp";
    @NonNls
    private static final String PROJECT_FILE_SUFFIX = ".ipr";
    private Project myProject;
    private Set<File> myFilesToDelete = new HashSet<File>();
    private IdeaTestApplication myApplication;
    private final List<ModuleFixtureBuilder> myModuleFixtureBuilders = new ArrayList<ModuleFixtureBuilder>();

    HeavyIdeaTestFixtureImpl() {
    }

    protected void addModuleFixtureBuilder(ModuleFixtureBuilder builder) {
        this.myModuleFixtureBuilders.add(builder);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.initApplication();
        this.setUpProject();
    }

    protected void setUpProject() throws Exception {
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        File projectFile = File.createTempFile(PROJECT_FILE_PREFIX, PROJECT_FILE_SUFFIX);
        this.myFilesToDelete.add(projectFile);
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(projectFile);
        this.myProject = projectManager.newProject(projectFile.getPath(), false, false);
        for (ModuleFixtureBuilder moduleFixtureBuilder : this.myModuleFixtureBuilders) {
            moduleFixtureBuilder.getFixture().setUp();
        }
        PropertiesReferenceManager.getInstance((Project)this.myProject).projectOpened();
        StartupManagerImpl sm = (StartupManagerImpl)StartupManager.getInstance(this.myProject);
        sm.runProjectConfigurationActivities();
        sm.runStartupActivities();
        sm.runPostStartupActivities();
        ProjectManagerEx.getInstanceEx().setCurrentTestProject(this.myProject);
    }

    protected void initApplication() throws Exception {
        this.myApplication = IdeaTestApplication.getInstance();
        this.myApplication.setDataProvider((DataProvider)new MyDataProvider());
    }

    public void tearDown() throws Exception {
        ProjectManagerEx.getInstanceEx().setCurrentTestProject(null);
        ApplicationManager.getApplication().runWriteAction(EmptyRunnable.getInstance());
        FileDocumentManager.getInstance().saveAllDocuments();
        HeavyIdeaTestFixtureImpl.doPostponedFormatting(this.myProject);
        Disposer.dispose(this.myProject);
        for (File fileToDelete : this.myFilesToDelete) {
            HeavyIdeaTestFixtureImpl.delete(fileToDelete);
        }
        this.myApplication.setDataProvider(null);
        EditorFactory editorFactory = EditorFactory.getInstance();
        Editor[] allEditors = editorFactory.getAllEditors();
        ((EditorFactoryImpl)editorFactory).validateEditorsAreReleased(this.getProject());
        for (Editor editor : allEditors) {
            editorFactory.releaseEditor(editor);
        }
        assert (0 == allEditors.length) : "There are unrealeased editors";
        super.tearDown();
    }

    public Project getProject() {
        assert (this.myProject != null) : "setUp() should be called first";
        return this.myProject;
    }

    public Module getModule() {
        return ModuleManager.getInstance(this.getProject()).getModules()[0];
    }

    private static void doPostponedFormatting(final Project project) {
        try {
            CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        public void run() {
                            PsiDocumentManager.getInstance(project).commitAllDocuments();
                            PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting();
                        }
                    });
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void delete(File file) {
        boolean b;
        if (file.isDirectory()) {
            File[] files;
            for (File fileToDelete : files = file.listFiles()) {
                HeavyIdeaTestFixtureImpl.delete(fileToDelete);
            }
        }
        if (!(b = file.delete()) && file.exists()) {
            throw new IllegalStateException("Can't delete " + file.getAbsolutePath());
        }
    }

    private class MyDataProvider
    implements DataProvider {
        private MyDataProvider() {
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (dataId.equals("project")) {
                return HeavyIdeaTestFixtureImpl.this.myProject;
            }
            if (dataId.equals("editor")) {
                return FileEditorManager.getInstance(HeavyIdeaTestFixtureImpl.this.myProject).getSelectedTextEditor();
            }
            return null;
        }
    }
}

