/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CodeCompletionHandler;
import com.intellij.codeInsight.completion.LookupData;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.PostHighlightingPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.mock.MockProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.testFramework.fixtures.impl.TempDirTextFixtureImpl;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeInsightTestFixtureImpl
extends BaseFixture
implements CodeInsightTestFixture {
    @NonNls
    private static final String PROFILE = "Configurable";
    private PsiManagerImpl myPsiManager;
    private PsiFile myFile;
    private Editor myEditor;
    private String myTestDataPath;
    private LocalInspectionTool[] myInspections;
    private final Map<String, LocalInspectionTool> myAvailableTools = new THashMap();
    private final Map<String, LocalInspectionToolWrapper> myAvailableLocalTools = new THashMap();
    private final TempDirTestFixture myTempDirFixture = new TempDirTextFixtureImpl();
    private final IdeaProjectTestFixture myProjectFixture;
    @NonNls
    private static final String XXX = "XXX";

    public CodeInsightTestFixtureImpl(IdeaProjectTestFixture projectFixture) {
        this.myProjectFixture = projectFixture;
    }

    @Override
    public void setTestDataPath(String dataPath) {
        this.myTestDataPath = dataPath;
    }

    @Override
    public String getTempDirPath() {
        return this.myTempDirFixture.getTempDirPath();
    }

    @Override
    public TempDirTestFixture getTempDirFixture() {
        return this.myTempDirFixture;
    }

    @Override
    public void enableInspections(LocalInspectionTool ... inspections) {
        this.myInspections = inspections;
    }

    @Override
    public void disableInspections(LocalInspectionTool ... inspections) {
        this.myAvailableTools.clear();
        this.myAvailableLocalTools.clear();
        ArrayList<LocalInspectionTool> tools = new ArrayList<LocalInspectionTool>(Arrays.asList(this.myInspections));
        Iterator<LocalInspectionTool> i = tools.iterator();
        block0: while (i.hasNext()) {
            LocalInspectionTool tool = i.next();
            for (LocalInspectionTool toRemove : inspections) {
                if (!tool.getShortName().equals(toRemove.getShortName())) continue;
                i.remove();
                continue block0;
            }
        }
        this.myInspections = tools.toArray(new LocalInspectionTool[tools.size()]);
        this.configureInspections(this.myInspections);
    }

    @Override
    public void enableInspections(InspectionToolProvider ... providers) {
        ArrayList<LocalInspectionTool> tools = new ArrayList<LocalInspectionTool>();
        for (InspectionToolProvider provider : providers) {
            for (Class clazz : provider.getInspectionClasses()) {
                try {
                    LocalInspectionTool inspection = (LocalInspectionTool)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    tools.add(inspection);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot instantiate " + clazz);
                }
            }
        }
        this.myInspections = tools.toArray(new LocalInspectionTool[tools.size()]);
    }

    @Override
    public long testHighlighting(final boolean checkWarnings, final boolean checkInfos, final boolean checkWeakWarnings, final String ... filePaths) throws Throwable {
        final Ref duration = new Ref();
        new WriteCommandAction.Simple(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                CodeInsightTestFixtureImpl.this.configureByFiles(filePaths);
                CodeInsightTestFixtureImpl.this.collectAndCheckHighlightings(checkWarnings, checkInfos, checkWeakWarnings, duration);
            }
        }.execute().throwException();
        return (Long)duration.get();
    }

    @Override
    public long testHighlighting(String ... filePaths) throws Throwable {
        return this.testHighlighting(true, true, true, filePaths);
    }

    @Override
    public long testHighlighting(final boolean checkWarnings, final boolean checkInfos, final boolean checkWeakWarnings, final VirtualFile file) throws Throwable {
        final Ref duration = new Ref();
        new WriteCommandAction.Simple(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                CodeInsightTestFixtureImpl.this.myFile = CodeInsightTestFixtureImpl.this.myPsiManager.findFile(file);
                CodeInsightTestFixtureImpl.this.myEditor = CodeInsightTestFixtureImpl.this.createEditor(file);
                CodeInsightTestFixtureImpl.this.collectAndCheckHighlightings(checkWarnings, checkInfos, checkWeakWarnings, duration);
            }
        }.execute().throwException();
        return (Long)duration.get();
    }

    @Override
    @Nullable
    public PsiReference getReferenceAtCaretPosition(final String filePath) throws Throwable {
        RunResult runResult = new WriteCommandAction<PsiReference>(this.myProjectFixture.getProject(), new PsiFile[0]){

            @Override
            protected void run(Result<PsiReference> result) throws Throwable {
                CodeInsightTestFixtureImpl.this.configureByFiles(new String[]{filePath});
                int offset = CodeInsightTestFixtureImpl.this.myEditor.getCaretModel().getOffset();
                PsiReference psiReference = CodeInsightTestFixtureImpl.this.getFile().findReferenceAt(offset);
                result.setResult(psiReference);
            }
        }.execute();
        runResult.throwException();
        return (PsiReference)runResult.getResultObject();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiReference getReferenceAtCaretPositionWithAssertion(String filePath) throws Throwable {
        PsiReference reference = this.getReferenceAtCaretPosition(filePath);
        assert (reference != null) : "no reference found at " + this.myEditor.getCaretModel().getLogicalPosition();
        PsiReference psiReference = reference;
        if (psiReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.getReferenceAtCaretPositionWithAssertion must not return null");
        }
        return psiReference;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions(final String ... filePaths) throws Throwable {
        final Project project = this.myProjectFixture.getProject();
        List list = (List)new WriteCommandAction<List<IntentionAction>>(project, new PsiFile[0]){

            @Override
            protected void run(Result<List<IntentionAction>> result) throws Throwable {
                int offset = CodeInsightTestFixtureImpl.this.configureByFiles(filePaths);
                result.setResult(CodeInsightTestFixtureImpl.getAvailableIntentions(project, CodeInsightTestFixtureImpl.this.doHighlighting(), offset, CodeInsightTestFixtureImpl.this.myEditor, CodeInsightTestFixtureImpl.this.myFile));
            }
        }.execute().getResultObject();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.getAvailableIntentions must not return null");
        }
        return list;
    }

    @Override
    public void launchAction(final @NotNull IntentionAction action) throws Throwable {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.launchAction must not be null");
        }
        new WriteCommandAction(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                action.invoke(this.getProject(), CodeInsightTestFixtureImpl.this.getEditor(), CodeInsightTestFixtureImpl.this.getFile());
            }
        }.execute().throwException();
    }

    @Override
    public void testCompletion(final String[] filesBefore, final String fileAfter) throws Throwable {
        new WriteCommandAction.Simple(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                CodeInsightTestFixtureImpl.this.configureByFiles(filesBefore);
                new CodeCompletionHandler().invoke(this.getProject(), CodeInsightTestFixtureImpl.this.myEditor, CodeInsightTestFixtureImpl.this.myFile);
                CodeInsightTestFixtureImpl.this.checkResultByFile(fileAfter, CodeInsightTestFixtureImpl.this.myFile, false);
            }
        }.execute().throwException();
    }

    @Override
    public void testCompletion(String fileBefore, String fileAfter) throws Throwable {
        this.testCompletion(new String[]{fileBefore}, fileAfter);
    }

    @Override
    public void testCompletionVariants(final String fileBefore, final String ... items) throws Throwable {
        new WriteCommandAction.Simple(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                CodeInsightTestFixtureImpl.this.configureByFiles(new String[]{fileBefore});
                final Ref<Object> myItems = Ref.create(null);
                new CodeCompletionHandler(){

                    protected Lookup showLookup(Project project, Editor editor, LookupItem[] items, String prefix, LookupData data, PsiFile file) {
                        myItems.set(items);
                        return null;
                    }
                }.invoke(this.getProject(), CodeInsightTestFixtureImpl.this.myEditor, CodeInsightTestFixtureImpl.this.myFile);
                LookupItem[] items1 = myItems.get();
                UsefulTestCase.assertNotNull((String)"No lookup was shown, probably there was only one lookup element that was inserted automatically", (Object)items1);
                UsefulTestCase.assertSameElements(ContainerUtil.map(items1, new Function<LookupItem, String>(){

                    @Override
                    public String fun(LookupItem lookupItem) {
                        return lookupItem.getLookupString();
                    }
                }), items);
            }
        }.execute().throwException();
    }

    @Override
    public void testRename(final String fileBefore, final String fileAfter, final String newName) throws Throwable {
        new WriteCommandAction.Simple(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                CodeInsightTestFixtureImpl.this.configureByFiles(new String[]{fileBefore});
                PsiElement element = TargetElementUtil.findTargetElement((Editor)CodeInsightTestFixtureImpl.this.myEditor, (int)1);
                assert (element != null) : "element not found at caret position, offset " + CodeInsightTestFixtureImpl.access$400(CodeInsightTestFixtureImpl.this).getCaretModel().getOffset();
                new RenameProcessor(CodeInsightTestFixtureImpl.this.myProjectFixture.getProject(), element, newName, false, false).run();
                CodeInsightTestFixtureImpl.this.checkResultByFile(fileAfter, CodeInsightTestFixtureImpl.this.myFile, false);
            }
        }.execute().throwException();
    }

    @Override
    public void moveFile(final @NonNls String filePath, final @NonNls String to) throws Throwable {
        final Project project = this.myProjectFixture.getProject();
        new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                CodeInsightTestFixtureImpl.this.configureByFile(filePath);
                VirtualFile file = CodeInsightTestFixtureImpl.this.findFile(to);
                assert (file.isDirectory()) : to + " is not a directory";
                PsiDirectory directory = CodeInsightTestFixtureImpl.this.myPsiManager.findDirectory(file);
                new MoveFilesOrDirectoriesProcessor(project, new PsiElement[]{CodeInsightTestFixtureImpl.this.myFile}, directory, false, false, null, null).run();
            }
        }.execute().throwException();
    }

    @Override
    @Nullable
    public GutterIconRenderer findGutter(final String filePath) throws Throwable {
        Project project = this.myProjectFixture.getProject();
        final Ref result = new Ref();
        new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                int offset = CodeInsightTestFixtureImpl.this.configureByFiles(new String[]{filePath});
                Collection infos = CodeInsightTestFixtureImpl.this.doHighlighting();
                for (HighlightInfo info : infos) {
                    GutterIconRenderer renderer;
                    if (info.endOffset < offset || info.startOffset > offset || (renderer = info.getGutterIconRenderer()) == null) continue;
                    result.set(renderer);
                    return;
                }
            }
        }.execute().throwException();
        return (GutterIconRenderer)result.get();
    }

    @Override
    public void checkResultByFile(final String filePath) throws Throwable {
        new WriteCommandAction.Simple(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                CodeInsightTestFixtureImpl.this.checkResultByFile(filePath, CodeInsightTestFixtureImpl.this.myFile, false);
            }
        }.execute().throwException();
    }

    @Override
    public void checkResultByFile(final String filePath, final String expectedFile, final boolean ignoreWhitespaces) throws Throwable {
        new WriteCommandAction.Simple(this.myProjectFixture.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                String fullPath = CodeInsightTestFixtureImpl.this.getTempDirPath() + "/" + filePath;
                VirtualFile copy = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath.replace(File.separatorChar, '/'));
                assert (copy != null) : "file not found: " + fullPath;
                PsiFile psiFile = CodeInsightTestFixtureImpl.this.myPsiManager.findFile(copy);
                assert (psiFile != null);
                CodeInsightTestFixtureImpl.this.checkResultByFile(expectedFile, psiFile, ignoreWhitespaces);
            }
        }.execute().throwException();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        String testDataPath = this.getTestDataPath();
        if (testDataPath != null) {
            FileUtil.copyDir(new File(testDataPath), new File(this.getTempDirPath()), false);
        }
        this.myProjectFixture.setUp();
        this.myPsiManager = (PsiManagerImpl)PsiManager.getInstance(this.getProject());
        this.configureInspections(this.myInspections == null ? new LocalInspectionTool[]{} : this.myInspections);
    }

    private void enableInspectionTool(LocalInspectionTool tool) {
        String shortName = tool.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find(shortName);
        if (key == null) {
            HighlightDisplayKey.register(shortName, tool.getDisplayName(), tool.getID());
        }
        this.myAvailableTools.put(shortName, tool);
        this.myAvailableLocalTools.put(shortName, new LocalInspectionToolWrapper(tool));
    }

    private void configureInspections(LocalInspectionTool[] tools) {
        for (LocalInspectionTool tool : tools) {
            this.enableInspectionTool(tool);
        }
        InspectionProfileImpl profile = new InspectionProfileImpl(PROFILE){

            public ModifiableModel getModifiableModel() {
                this.mySource = this;
                return this;
            }

            public InspectionProfileEntry[] getInspectionTools() {
                Collection tools = CodeInsightTestFixtureImpl.this.myAvailableLocalTools.values();
                return (InspectionProfileEntry[])tools.toArray(new LocalInspectionToolWrapper[tools.size()]);
            }

            public boolean isToolEnabled(HighlightDisplayKey key) {
                return key != null && key.toString() != null && CodeInsightTestFixtureImpl.this.myAvailableTools != null && CodeInsightTestFixtureImpl.this.myAvailableTools.containsKey(key.toString());
            }

            public HighlightDisplayLevel getErrorLevel(HighlightDisplayKey key) {
                LocalInspectionTool localInspectionTool = (LocalInspectionTool)CodeInsightTestFixtureImpl.this.myAvailableTools.get(key.toString());
                return localInspectionTool != null ? localInspectionTool.getDefaultLevel() : HighlightDisplayLevel.WARNING;
            }

            public InspectionTool getInspectionTool(String shortName) {
                return (InspectionTool)CodeInsightTestFixtureImpl.this.myAvailableLocalTools.get(shortName);
            }
        };
        final InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
        inspectionProfileManager.addProfile((Profile)profile);
        Disposer.register(this.getProject(), new Disposable(){

            public void dispose() {
                inspectionProfileManager.deleteProfile(CodeInsightTestFixtureImpl.PROFILE);
            }
        });
        inspectionProfileManager.setRootProfile(profile.getName());
        InspectionProjectProfileManager.getInstance((Project)this.getProject()).updateProfile((Profile)profile);
    }

    @Override
    public void tearDown() throws Exception {
        VirtualFile[] openFiles;
        LookupManager.getInstance((Project)this.getProject()).hideActiveLookup();
        FileEditorManager editorManager = FileEditorManager.getInstance(this.getProject());
        for (VirtualFile openFile : openFiles = editorManager.getOpenFiles()) {
            editorManager.closeFile(openFile);
        }
        this.myProjectFixture.tearDown();
        this.myTempDirFixture.tearDown();
        super.tearDown();
    }

    private int configureByFiles(String ... filePaths) throws IOException {
        this.myFile = null;
        this.myEditor = null;
        int offset = -1;
        for (int i = filePaths.length - 1; i >= 0; --i) {
            String filePath = filePaths[i];
            int fileOffset = this.configureByFileInner(filePath);
            if (fileOffset <= 0) continue;
            offset = fileOffset;
        }
        return offset;
    }

    @Override
    public void configureByFile(final String file) throws IOException {
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                CodeInsightTestFixtureImpl.this.configureByFileInner(file);
            }
        }.execute();
    }

    private int configureByFileInner(@NonNls String filePath) throws IOException {
        VirtualFile copy = this.findFile(filePath);
        SelectionAndCaretMarkupLoader loader = new SelectionAndCaretMarkupLoader(copy.getPath());
        try {
            OutputStream outputStream = copy.getOutputStream(null, 0L, 0L);
            outputStream.write(loader.newFileText.getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.myFile = this.myPsiManager.findFile(copy);
        int offset = -1;
        this.myEditor = this.createEditor(copy);
        assert (this.myEditor != null);
        if (loader.caretMarker != null) {
            offset = loader.caretMarker.getStartOffset();
            this.myEditor.getCaretModel().moveToOffset(offset);
        }
        if (loader.selStartMarker != null && loader.selEndMarker != null) {
            this.myEditor.getSelectionModel().setSelection(loader.selStartMarker.getStartOffset(), loader.selEndMarker.getStartOffset());
        }
        return offset;
    }

    private VirtualFile findFile(String filePath) {
        String fullPath = this.getTempDirPath() + "/" + filePath;
        VirtualFile copy = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath.replace(File.separatorChar, '/'));
        assert (copy != null) : "file " + fullPath + " not found";
        return copy;
    }

    @Nullable
    private Editor createEditor(VirtualFile file) {
        Project project = this.getProject();
        FileEditorManager instance = FileEditorManager.getInstance(project);
        if (file.getFileType().isBinary()) {
            return null;
        }
        return instance.openTextEditor(new OpenFileDescriptor(project, file, 0), false);
    }

    private void collectAndCheckHighlightings(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, Ref<Long> duration) throws Exception {
        Project project = this.getProject();
        ExpectedHighlightingData data = new ExpectedHighlightingData(this.myEditor.getDocument(), checkWarnings, checkWeakWarnings, checkInfos, this.myFile);
        PsiDocumentManager.getInstance(project).commitAllDocuments();
        ((PsiFileImpl)this.myFile).calcTreeElement();
        this.myPsiManager.getCacheManager().getFilesWithWord(XXX, (short)2, GlobalSearchScope.allScope(project), true);
        VirtualFileFilter javaFilesFilter = new VirtualFileFilter(){

            public boolean accept(VirtualFile file) {
                FileType fileType = FileTypeManager.getInstance().getFileTypeByFile(file);
                return fileType == StdFileTypes.JAVA || fileType == StdFileTypes.CLASS;
            }
        };
        this.myPsiManager.setAssertOnFileLoadingFilter(javaFilesFilter);
        long start = System.currentTimeMillis();
        Collection<HighlightInfo> infos = this.doHighlighting();
        duration.set(System.currentTimeMillis() - start);
        this.myPsiManager.setAssertOnFileLoadingFilter(VirtualFileFilter.NONE);
        data.checkResult(infos, this.myEditor.getDocument().getText());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Collection<HighlightInfo> doHighlighting() {
        Project project = this.myProjectFixture.getProject();
        PsiDocumentManager.getInstance(project).commitAllDocuments();
        Document document = this.myEditor.getDocument();
        GeneralHighlightingPass action1 = new GeneralHighlightingPass(project, this.myFile, document, 0, this.myFile.getTextLength(), true);
        action1.doCollectInformation((ProgressIndicator)new MockProgressIndicator());
        Collection highlights1 = action1.getHighlights();
        PostHighlightingPass action2 = new PostHighlightingPass(project, this.myFile, this.myEditor, 0, this.myFile.getTextLength());
        action2.doCollectInformation((ProgressIndicator)new MockProgressIndicator());
        Collection highlights2 = action2.getHighlights();
        Collection highlights3 = null;
        if (this.myAvailableTools.size() > 0) {
            LocalInspectionsPass inspectionsPass = new LocalInspectionsPass(this.myFile, this.myEditor.getDocument(), 0, this.myFile.getTextLength());
            inspectionsPass.doCollectInformation((ProgressIndicator)new MockProgressIndicator());
            highlights3 = inspectionsPass.getHighlights();
        }
        ArrayList<HighlightInfo> list = new ArrayList<HighlightInfo>();
        for (HighlightInfo info : highlights1) {
            list.add(info);
        }
        for (HighlightInfo info : highlights2) {
            list.add(info);
        }
        if (highlights3 != null) {
            for (HighlightInfo info : highlights3) {
                list.add(info);
            }
        }
        ArrayList<HighlightInfo> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.doHighlighting must not return null");
        }
        return arrayList;
    }

    private String getTestDataPath() {
        return this.myTestDataPath;
    }

    @Override
    public Project getProject() {
        return this.myProjectFixture.getProject();
    }

    @Override
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    public PsiFile getFile() {
        return this.myFile;
    }

    public static List<IntentionAction> getAvailableIntentions(Project project, Collection<HighlightInfo> infos, int offset, Editor editor, PsiFile file) {
        ArrayList<IntentionAction> availableActions = new ArrayList<IntentionAction>();
        for (HighlightInfo info : infos) {
            if (info.quickFixActionRanges == null) continue;
            for (Pair pair : info.quickFixActionRanges) {
                HighlightInfo.IntentionActionDescriptor actionDescriptor;
                IntentionAction action;
                if (offset > 0 && !((TextRange)pair.getSecond()).contains(offset) || !(action = (actionDescriptor = (HighlightInfo.IntentionActionDescriptor)pair.first).getAction()).isAvailable(project, editor, file)) continue;
                availableActions.add(action);
                List actions = actionDescriptor.getOptions(file.findElementAt(editor.getCaretModel().getOffset()));
                if (actions == null) continue;
                for (IntentionAction intentionAction : actions) {
                    if (!intentionAction.isAvailable(project, editor, file)) continue;
                    availableActions.add(intentionAction);
                }
            }
        }
        for (IntentionAction intentionAction : IntentionManager.getInstance().getIntentionActions()) {
            if (!intentionAction.isAvailable(project, editor, file)) continue;
            availableActions.add(intentionAction);
        }
        return availableActions;
    }

    private void checkResultByFile(@NonNls String expectedFile, @NotNull PsiFile originalFile, boolean stripTrailingSpaces) throws IOException {
        if (originalFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl.checkResultByFile must not be null");
        }
        Project project = this.myProjectFixture.getProject();
        project.getComponent(PostprocessReformattingAspect.class).doPostponedFormatting();
        if (stripTrailingSpaces) {
            ((DocumentEx)this.myEditor.getDocument()).stripTrailingSpaces(false);
        }
        PsiDocumentManager.getInstance(project).commitAllDocuments();
        SelectionAndCaretMarkupLoader loader = new SelectionAndCaretMarkupLoader(this.getTestDataPath() + "/" + expectedFile);
        String newFileText1 = loader.newFileText;
        if (stripTrailingSpaces) {
            Document document1 = EditorFactory.getInstance().createDocument(loader.newFileText);
            ((DocumentEx)document1).stripTrailingSpaces(false);
            newFileText1 = document1.getText();
        }
        String text = originalFile.getText();
        text = StringUtil.convertLineSeparators(text, "\n");
        TestCase.assertEquals((String)("Text mismatch in file " + expectedFile), (String)newFileText1, (String)text);
        if (loader.caretMarker != null) {
            int caretLine = StringUtil.offsetToLineNumber(loader.newFileText, loader.caretMarker.getStartOffset());
            int caretCol = loader.caretMarker.getStartOffset() - StringUtil.lineColToOffset(loader.newFileText, caretLine, 0);
            TestCase.assertEquals((String)"caretLine", (int)(caretLine + 1), (int)(this.myEditor.getCaretModel().getLogicalPosition().line + 1));
            TestCase.assertEquals((String)"caretColumn", (int)(caretCol + 1), (int)(this.myEditor.getCaretModel().getLogicalPosition().column + 1));
        }
        if (loader.selStartMarker != null && loader.selEndMarker != null) {
            int selStartLine = StringUtil.offsetToLineNumber(loader.newFileText, loader.selStartMarker.getStartOffset());
            int selStartCol = loader.selStartMarker.getStartOffset() - StringUtil.lineColToOffset(loader.newFileText, selStartLine, 0);
            int selEndLine = StringUtil.offsetToLineNumber(loader.newFileText, loader.selEndMarker.getEndOffset());
            int selEndCol = loader.selEndMarker.getEndOffset() - StringUtil.lineColToOffset(loader.newFileText, selEndLine, 0);
            TestCase.assertEquals((String)"selectionStartLine", (int)(selStartLine + 1), (int)(StringUtil.offsetToLineNumber(loader.newFileText, this.myEditor.getSelectionModel().getSelectionStart()) + 1));
            TestCase.assertEquals((String)"selectionStartCol", (int)(selStartCol + 1), (int)(this.myEditor.getSelectionModel().getSelectionStart() - StringUtil.lineColToOffset(loader.newFileText, selStartLine, 0) + 1));
            TestCase.assertEquals((String)"selectionEndLine", (int)(selEndLine + 1), (int)(StringUtil.offsetToLineNumber(loader.newFileText, this.myEditor.getSelectionModel().getSelectionEnd()) + 1));
            TestCase.assertEquals((String)"selectionEndCol", (int)(selEndCol + 1), (int)(this.myEditor.getSelectionModel().getSelectionEnd() - StringUtil.lineColToOffset(loader.newFileText, selEndLine, 0) + 1));
        } else {
            TestCase.assertTrue((String)"has no selection", (!this.myEditor.getSelectionModel().hasSelection() ? 1 : 0) != 0);
        }
    }

    static class SelectionAndCaretMarkupLoader {
        final String newFileText;
        final RangeMarker caretMarker;
        final RangeMarker selStartMarker;
        final RangeMarker selEndMarker;

        SelectionAndCaretMarkupLoader(String fullPath) throws IOException {
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath.replace(File.separatorChar, '/'));
            assert (vFile != null) : "Cannot find file " + fullPath;
            vFile.refresh(false, false);
            String fileText = StringUtil.convertLineSeparators(VfsUtil.loadText(vFile), "\n");
            Document document = EditorFactory.getInstance().createDocument(fileText);
            int caretIndex = fileText.indexOf("<caret>");
            int selStartIndex = fileText.indexOf("<selection>");
            int selEndIndex = fileText.indexOf("</selection>");
            this.caretMarker = caretIndex >= 0 ? document.createRangeMarker(caretIndex, caretIndex) : null;
            this.selStartMarker = selStartIndex >= 0 ? document.createRangeMarker(selStartIndex, selStartIndex) : null;
            RangeMarker rangeMarker = this.selEndMarker = selEndIndex >= 0 ? document.createRangeMarker(selEndIndex, selEndIndex) : null;
            if (this.caretMarker != null) {
                document.deleteString(this.caretMarker.getStartOffset(), this.caretMarker.getStartOffset() + "<caret>".length());
            }
            if (this.selStartMarker != null) {
                document.deleteString(this.selStartMarker.getStartOffset(), this.selStartMarker.getStartOffset() + "<selection>".length());
            }
            if (this.selEndMarker != null) {
                document.deleteString(this.selEndMarker.getStartOffset(), this.selEndMarker.getStartOffset() + "</selection>".length());
            }
            this.newFileText = document.getText();
        }
    }
}

