/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeInsightTestUtil {
    private CodeInsightTestUtil() {
    }

    @Nullable
    public static IntentionAction findIntentionByText(List<IntentionAction> actions, @NonNls String text) {
        for (IntentionAction action : actions) {
            String s = action.getText();
            if (!s.equals(text)) continue;
            return action;
        }
        return null;
    }

    public static void doIntentionTest(CodeInsightTestFixture fixture, @NonNls String file, @NonNls String actionText) throws Throwable {
        List<IntentionAction> list = fixture.getAvailableIntentions(file + ".xml");
        assert (list.size() > 0);
        IntentionAction intentionAction = CodeInsightTestUtil.findIntentionByText(list, actionText);
        assert (intentionAction != null) : "Action not found: " + actionText;
        fixture.launchAction(intentionAction);
        fixture.checkResultByFile(file + "_after.xml");
    }
}

