/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UsefulTestCase
extends TestCase {
    protected Disposable myTestRootDisposable;
    protected Disposable myUiResourcesRoot;

    protected void setUp() throws Exception {
        super.setUp();
        this.myTestRootDisposable = new Disposable(){

            public void dispose() {
            }
        };
    }

    protected void tearDown() throws Exception {
        Disposer.dispose(this.myTestRootDisposable);
        this.myTestRootDisposable = null;
        super.tearDown();
    }

    protected Disposable getTestRootDisposable() {
        return this.myTestRootDisposable;
    }

    @NonNls
    public static String toString(Collection collection) {
        if (collection.isEmpty()) {
            return "<empty>";
        }
        StringBuilder builder = new StringBuilder();
        for (Object o : collection) {
            if (o instanceof THashSet) {
                builder.append(new TreeSet((Collection)o));
            } else {
                builder.append(o);
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public static <T> void assertOrderedEquals(T[] actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals(Arrays.asList(actual), expected);
    }

    public static <T> void assertOrderedEquals(Collection<T> actual, T ... expected) {
        UsefulTestCase.assertNotNull(actual);
        UsefulTestCase.assertNotNull(expected);
        UsefulTestCase.assertOrderedEquals(Arrays.asList(expected), actual);
    }

    public static <T> void assertOrderedEquals(Collection<? extends T> actual, Collection<? extends T> expected) {
        if (!new ArrayList<T>(actual).equals(expected)) {
            UsefulTestCase.assertEquals((String)UsefulTestCase.toString(expected), (String)UsefulTestCase.toString(actual));
            UsefulTestCase.fail();
        }
    }

    public static <T> void assertOrderedCollection(T[] collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertNotNull(collection);
        UsefulTestCase.assertOrderedCollection(Arrays.asList(collection), checkers);
    }

    public static <T> void assertSameElements(T[] collection, T ... expected) {
        UsefulTestCase.assertSameElements(Arrays.asList(collection), expected);
    }

    public static <T> void assertSameElements(Collection<? extends T> collection, T ... expected) {
        if (!new HashSet<T>(Arrays.asList(expected)).equals(new HashSet<T>(collection))) {
            UsefulTestCase.assertEquals((String)UsefulTestCase.toString(expected, "\n"), (String)UsefulTestCase.toString(collection, "\n"));
            UsefulTestCase.assertEquals(new HashSet<T>(Arrays.asList(expected)), new HashSet<T>(collection));
        }
    }

    public static String toString(Object[] collection, String separator) {
        return UsefulTestCase.toString(Arrays.asList(collection), separator);
    }

    public static String toString(Collection collection, String separator) {
        List<String> list = ContainerUtil.map2List(collection, new Function(){

            public Object fun(Object o) {
                return String.valueOf(o);
            }
        });
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (String o : list) {
            if (flag) {
                builder.append(separator);
            }
            builder.append(o);
            flag = true;
        }
        return builder.toString();
    }

    public static <T> void assertOrderedCollection(Collection<T> collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertNotNull(collection);
        if (collection.size() != checkers.length) {
            UsefulTestCase.fail((String)UsefulTestCase.toString(collection));
        }
        int i = 0;
        for (T actual : collection) {
            try {
                checkers[i].consume(actual);
            }
            catch (AssertionFailedError e) {
                System.out.println(i + ": " + actual);
                throw e;
            }
            ++i;
        }
    }

    public static <T> void assertUnorderedCollection(T[] collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertUnorderedCollection(Arrays.asList(collection), checkers);
    }

    public static <T> void assertUnorderedCollection(Collection<? extends T> collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertNotNull(collection);
        if (collection.size() != checkers.length) {
            UsefulTestCase.fail((String)UsefulTestCase.toString(collection));
        }
        HashSet<Consumer<T>> checkerSet = new HashSet<Consumer<T>>(Arrays.asList(checkers));
        int i = 0;
        for (T actual : collection) {
            boolean flag = true;
            for (Consumer consumer : checkerSet) {
                if (!UsefulTestCase.accepts(consumer, actual)) continue;
                checkerSet.remove(consumer);
                flag = false;
                break;
            }
            if (flag) {
                UsefulTestCase.fail((String)("Incorrect element(" + i + "): " + actual));
            }
            ++i;
        }
    }

    private static <T> boolean accepts(Consumer<T> condition, T actual) {
        try {
            condition.consume(actual);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static <T> T assertInstanceOf(Object o, Class<T> aClass) {
        UsefulTestCase.assertNotNull((Object)o);
        UsefulTestCase.assertTrue((String)o.getClass().getName(), (boolean)aClass.isInstance(o));
        return (T)o;
    }

    public static <T> T assertOneElement(Collection<T> collection) {
        UsefulTestCase.assertNotNull(collection);
        UsefulTestCase.assertEquals((int)1, (int)collection.size());
        return collection.iterator().next();
    }

    public static <T> T assertOneElement(T[] ts) {
        UsefulTestCase.assertNotNull(ts);
        UsefulTestCase.assertEquals((int)1, (int)ts.length);
        return ts[0];
    }

    public static void printThreadDump() {
        Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : traces.entrySet()) {
            StackTraceElement[] value;
            System.out.println("\n" + entry.getKey().getName() + "\n");
            for (StackTraceElement stackTraceElement : value = entry.getValue()) {
                System.out.println(stackTraceElement);
            }
        }
    }

    public static void assertEmpty(Object[] array) {
        UsefulTestCase.assertOrderedEquals(array, new Object[0]);
    }

    public static void assertEmpty(Collection collection) {
        UsefulTestCase.assertOrderedEquals(collection, new Object[0]);
    }

    protected <T extends Disposable> T disposeOnTearDown(T disposable) {
        Disposer.register(this.myTestRootDisposable, disposable);
        return disposable;
    }

    public static void assertSameLines(String expected, String actual) {
        String expectedText = StringUtil.convertLineSeparators(expected.trim());
        String actualText = StringUtil.convertLineSeparators(actual.trim());
        UsefulTestCase.assertEquals((String)expectedText, (String)actualText);
    }

    protected String getTestName(boolean lowercaseFirstLetter) {
        String name = this.getName();
        UsefulTestCase.assertTrue((boolean)name.startsWith("test"));
        name = name.substring("test".length());
        if (lowercaseFirstLetter) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    protected static void assertSameLinesWithFile(String filePath, String actualText) {
        String fileText;
        try {
            FileReader reader = new FileReader(filePath);
            fileText = FileUtil.loadTextAndClose(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        UsefulTestCase.assertSameLines(fileText, actualText);
    }

    public static void clearFields(Object test) throws IllegalAccessException {
        for (Class<?> aClass = test.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                int modifiers;
                String name = field.getDeclaringClass().getName();
                if (name.startsWith("junit.framework.") || name.startsWith("com.intellij.testFramework.") || ((modifiers = field.getModifiers()) & 0x10) != 0 || (modifiers & 8) != 0 || field.getType().isPrimitive()) continue;
                field.setAccessible(true);
                field.set(test, null);
            }
        }
    }
}

