/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.testFramework.IdeaTestCase;
import java.io.File;
import org.jetbrains.annotations.NonNls;

@NonNls
public abstract class TestSourceBasedTestCase
extends IdeaTestCase {
    private File myTempDirectory;

    protected void setUp() throws Exception {
        super.setUp();
        this.myTempDirectory = FileUtil.createTempDirectory("testCopy", "test");
        myFilesToDelete.add(this.getTestContentFile());
        File testRoot = new File(PathManagerEx.getTestDataPath(), this.getTestPath());
        TestSourceBasedTestCase.assertTrue((String)testRoot.getAbsolutePath(), (boolean)testRoot.isDirectory());
        File currentTestRoot = new File(testRoot, this.getTestDirectoryName());
        TestSourceBasedTestCase.assertTrue((String)currentTestRoot.getAbsolutePath(), (boolean)currentTestRoot.isDirectory());
        FileUtil.copyDir(currentTestRoot, new File(this.myTempDirectory, this.getTestDirectoryName()));
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            public void run() {
                TestSourceBasedTestCase.this.setupContentRoot();
            }
        });
    }

    protected abstract String getTestPath();

    private File getTestContentFile() {
        return new File(this.myTempDirectory, this.getTestDirectoryName());
    }

    private void setupContentRoot() {
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance(this.myModule).getModifiableModel();
        ContentEntry contentEntry = modifiableModel.addContentEntry(this.getContentRoot());
        VirtualFile src = this.getContentRoot().findChild("src");
        if (src != null) {
            contentEntry.addSourceFolder(src, false);
        }
        modifiableModel.commit();
    }

    protected VirtualFile getContentRoot() {
        File file = this.getTestContentFile();
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    protected String getTestDirectoryName() {
        return this.getTestName(true);
    }

    protected PsiDirectory getPackageDirectory(String packageRelativePath) {
        return this.getPsiManager().findDirectory(this.getContentRoot().findFileByRelativePath("src/" + packageRelativePath));
    }

    protected PsiDirectory getSrcDirectory() {
        return this.getPsiManager().findDirectory(this.getContentRoot().findFileByRelativePath("src"));
    }

    protected PsiDirectory getContentDirectory() {
        return this.getPsiManager().findDirectory(this.getContentRoot());
    }

    protected String getRootFiles() {
        return " " + this.myModule.getModuleFile().getName() + "\n" + " " + this.myProject.getName() + ".ipr\n";
    }
}

