/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.EditorDataProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.HashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNls
public class TestEditorManagerImpl
extends FileEditorManagerEx
implements ApplicationComponent,
ProjectComponent {
    private static final Logger LOG = Logger.getInstance("#com.intellij.idea.test.TestEditorManagerImpl");
    private final Project myProject;
    private Map<VirtualFile, Editor> myVirtualFile2Editor = new HashMap<VirtualFile, Editor>();
    private VirtualFile myActiveFile = null;
    private static final LightVirtualFile LIGHT_VIRTUAL_FILE = new LightVirtualFile("Dummy.java");

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file, boolean focusEditor) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.openFileWithProviders must not be null");
        }
        Editor editor = this.openTextEditor(new OpenFileDescriptor(this.myProject, file), focusEditor);
        TextEditor fileEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        Pair<FileEditor[], FileEditorProvider[]> pair = Pair.create(new FileEditor[]{fileEditor}, new FileEditorProvider[]{this.getProvider(fileEditor)});
        if (pair == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/TestEditorManagerImpl.openFileWithProviders must not return null");
        }
        return pair;
    }

    public boolean isInsideChange() {
        return false;
    }

    public void createSplitter(int orientation) {
    }

    public void changeSplitterOrientation() {
    }

    public void flipTabs() {
    }

    public boolean tabsMode() {
        return false;
    }

    public boolean isInSplitter() {
        return false;
    }

    public boolean hasOpenedFile() {
        return false;
    }

    public VirtualFile getCurrentFile() {
        return null;
    }

    public Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.getSelectedEditorWithProvider must not be null");
        }
        return null;
    }

    public boolean isChanged(@NotNull EditorComposite editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.isChanged must not be null");
        }
        return false;
    }

    public EditorWindow getNextWindow(@NotNull EditorWindow window) {
        if (window == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.getNextWindow must not be null");
        }
        return null;
    }

    public EditorWindow getPrevWindow(@NotNull EditorWindow window) {
        if (window == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.getPrevWindow must not be null");
        }
        return null;
    }

    public void addTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.addTopComponent must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.addTopComponent must not be null");
        }
    }

    public void removeTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.removeTopComponent must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.removeTopComponent must not be null");
        }
    }

    public void addBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.addBottomComponent must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.addBottomComponent must not be null");
        }
    }

    public void removeBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.removeBottomComponent must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.removeBottomComponent must not be null");
        }
    }

    public void closeAllFiles() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        for (VirtualFile file : this.myVirtualFile2Editor.keySet()) {
            Editor editor = this.myVirtualFile2Editor.get(file);
            if (editor == null) continue;
            editorFactory.releaseEditor(editor);
        }
        this.myVirtualFile2Editor.clear();
    }

    public Editor openTextEditorEnsureNoFocus(@NotNull OpenFileDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.openTextEditorEnsureNoFocus must not be null");
        }
        return this.openTextEditor(descriptor, false);
    }

    public FileEditorProvider getProvider(FileEditor editor) {
        return new FileEditorProvider(){

            public boolean accept(Project project, VirtualFile file) {
                return false;
            }

            public FileEditor createEditor(Project project, VirtualFile file) {
                return null;
            }

            public void disposeEditor(FileEditor editor) {
            }

            @NotNull
            public FileEditorState readState(Element sourceElement, Project project, VirtualFile file) {
                if (null == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/testFramework/TestEditorManagerImpl$1.readState must not return null");
                }
                return null;
            }

            public void writeState(FileEditorState state, Project project, Element targetElement) {
            }

            @NotNull
            public String getEditorTypeId() {
                if ("" == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/testFramework/TestEditorManagerImpl$1.getEditorTypeId must not return null");
                }
                return "";
            }

            public FileEditorPolicy getPolicy() {
                return null;
            }
        };
    }

    public EditorWindow getCurrentWindow() {
        return null;
    }

    public void setCurrentWindow(EditorWindow window) {
    }

    public VirtualFile getFile(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.getFile must not be null");
        }
        return LIGHT_VIRTUAL_FILE;
    }

    public boolean hasTabGroups() {
        throw new UnsupportedOperationException();
    }

    public boolean isFilePinned(VirtualFile file) {
        throw new UnsupportedOperationException();
    }

    public void setFilePinned(VirtualFile file, boolean pinned) {
        throw new UnsupportedOperationException();
    }

    public void unsplitWindow() {
    }

    public void unsplitAllWindow() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public EditorWindow[] getWindows() {
        EditorWindow[] editorWindowArray = new EditorWindow[]{};
        if (editorWindowArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/TestEditorManagerImpl.getWindows must not return null");
        }
        return editorWindowArray;
    }

    public int getTabGroupsOrientation() {
        throw new UnsupportedOperationException();
    }

    public void setTabGroupsOrientation(int orientation) {
        throw new UnsupportedOperationException();
    }

    public void moveToOppositeTabGroup(VirtualFile file) {
        throw new UnsupportedOperationException();
    }

    public FileEditor getSelectedEditor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.getSelectedEditor must not be null");
        }
        Editor editor = this.getEditor(file);
        return editor == null ? null : TextEditorProvider.getInstance().getTextEditor(editor);
    }

    public boolean isFileOpen(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.isFileOpen must not be null");
        }
        return this.getEditor(file) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public FileEditor[] getEditors(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.getEditors must not be null");
        }
        FileEditor[] fileEditorArray = new FileEditor[]{this.getSelectedEditor(file)};
        if (fileEditorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/TestEditorManagerImpl.getEditors must not return null");
        }
        return fileEditorArray;
    }

    public TestEditorManagerImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public VirtualFile[] getSiblings(VirtualFile file) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disposeComponent() {
        this.closeAllFiles();
    }

    @Override
    public void initComponent() {
    }

    @Override
    public void projectClosed() {
    }

    @Override
    public void projectOpened() {
    }

    public void closeFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.closeFile must not be null");
        }
        Editor editor = this.myVirtualFile2Editor.get(file);
        if (editor != null) {
            EditorFactory.getInstance().releaseEditor(editor);
            this.myVirtualFile2Editor.remove(file);
        }
    }

    public void closeFile(@NotNull VirtualFile file, @NotNull EditorWindow window) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.closeFile must not be null");
        }
        if (window == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.closeFile must not be null");
        }
        this.closeFile(file);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VirtualFile[] getSelectedFiles() {
        VirtualFile[] virtualFileArray;
        if (this.myActiveFile == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = this.myActiveFile;
        }
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/TestEditorManagerImpl.getSelectedFiles must not return null");
        }
        return virtualFileArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public FileEditor[] getSelectedEditors() {
        FileEditor[] fileEditorArray = new FileEditor[]{};
        if (fileEditorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/TestEditorManagerImpl.getSelectedEditors must not return null");
        }
        return fileEditorArray;
    }

    public Editor getSelectedTextEditor() {
        return this.myActiveFile != null ? this.getEditor(this.myActiveFile) : null;
    }

    public JComponent getComponent() {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VirtualFile[] getOpenFiles() {
        VirtualFile[] virtualFileArray = this.myVirtualFile2Editor.keySet().toArray(new VirtualFile[this.myVirtualFile2Editor.size()]);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/TestEditorManagerImpl.getOpenFiles must not return null");
        }
        return virtualFileArray;
    }

    public Editor getEditor(VirtualFile file) {
        return this.myVirtualFile2Editor.get(this.myActiveFile);
    }

    @NotNull
    public FileEditor[] getAllEditors() {
        throw new UnsupportedOperationException();
    }

    public void showEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComoponent) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.showEditorAnnotation must not be null");
        }
        if (annotationComoponent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.showEditorAnnotation must not be null");
        }
    }

    public void removeEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComoponent) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.removeEditorAnnotation must not be null");
        }
        if (annotationComoponent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.removeEditorAnnotation must not be null");
        }
    }

    public void registerFileAsOpened(VirtualFile file, Editor editor) {
        this.myVirtualFile2Editor.put(file, editor);
        this.myActiveFile = file;
    }

    public Editor openTextEditor(OpenFileDescriptor descriptor, boolean focusEditor) {
        VirtualFile file = descriptor.getFile();
        Editor editor = this.myVirtualFile2Editor.get(file);
        if (editor == null) {
            PsiFile psiFile = PsiManager.getInstance(this.myProject).findFile(file);
            LOG.assertTrue(psiFile != null);
            Document document = PsiDocumentManager.getInstance(this.myProject).getDocument(psiFile);
            editor = EditorFactory.getInstance().createEditor(document, this.myProject);
            ((EditorEx)editor).setHighlighter(HighlighterFactory.createHighlighter((Project)this.myProject, (VirtualFile)file));
            this.myVirtualFile2Editor.put(file, editor);
        }
        if (descriptor.getOffset() >= 0) {
            editor.getCaretModel().moveToOffset(descriptor.getOffset());
        } else if (descriptor.getLine() >= 0 && descriptor.getColumn() >= 0) {
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(descriptor.getLine(), descriptor.getColumn()));
        }
        editor.getSelectionModel().removeSelection();
        this.myActiveFile = file;
        return editor;
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.addFileEditorManagerListener must not be null");
        }
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener, Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.addFileEditorManagerListener must not be null");
        }
    }

    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.removeFileEditorManagerListener must not be null");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<FileEditor> openEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.openEditor must not be null");
        }
        List<FileEditor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/TestEditorManagerImpl.openEditor must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/TestEditorManagerImpl.getProject must not return null");
        }
        return project;
    }

    public void registerExtraEditorDataProvider(@NotNull EditorDataProvider provider, Disposable parentDisposable) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.registerExtraEditorDataProvider must not be null");
        }
    }

    public JComponent getPreferredFocusedComponent() {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/TestEditorManagerImpl.getEditorsWithProviders must not be null");
        }
        throw new IllegalStateException("@NotNull method com/intellij/testFramework/TestEditorManagerImpl.getEditorsWithProviders must not return null");
    }

    @Override
    public String getComponentName() {
        return "TestEditorManager";
    }
}

