/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiReference;
import com.intellij.testFramework.PsiTestCase;
import java.io.File;
import org.jetbrains.annotations.NonNls;

public abstract class ResolveTestCase
extends PsiTestCase {
    protected static final String MARKER = "<ref>";

    protected PsiReference configureByFile(@NonNls String filePath) throws Exception {
        String fullPath = this.getTestDataPath() + filePath;
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(fullPath.replace(File.separatorChar, '/'));
        ResolveTestCase.assertNotNull((String)("file " + filePath + " not found"), (Object)vFile);
        String fileText = StringUtil.convertLineSeparators(VfsUtil.loadText(vFile), "\n");
        String fileName = vFile.getName();
        return this.configureByFileText(fileText, fileName);
    }

    protected PsiReference configureByFileText(String fileText, String fileName) throws Exception {
        int offset = fileText.indexOf(MARKER);
        ResolveTestCase.assertTrue((offset >= 0 ? 1 : 0) != 0);
        fileText = fileText.substring(0, offset) + fileText.substring(offset + MARKER.length());
        this.myFile = this.createFile(fileName, fileText);
        PsiReference ref = this.myFile.findReferenceAt(offset);
        ResolveTestCase.assertNotNull((Object)ref);
        return ref;
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath() + "/psi/resolve/";
    }
}

