/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import junit.framework.Assert;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNls
public class PsiTestUtil {
    public static VirtualFile createTestProjectStructure(Project project, Module module, String rootPath, Collection<File> filesToDelete) throws Exception {
        return PsiTestUtil.createTestProjectStructure(project, module, rootPath, filesToDelete, true);
    }

    public static VirtualFile createTestProjectStructure(Project project, Module module, Collection<File> filesToDelete) throws Exception {
        return PsiTestUtil.createTestProjectStructure(project, module, null, filesToDelete, true);
    }

    public static VirtualFile createTestProjectStructure(Project project, Module module, String rootPath, Collection<File> filesToDelete, boolean addProjectRoots) throws Exception {
        VirtualFile vDir = PsiTestUtil.createTestProjectStructure(module, rootPath, filesToDelete, addProjectRoots);
        PsiDocumentManager.getInstance(project).commitAllDocuments();
        return vDir;
    }

    public static VirtualFile createTestProjectStructure(Module module, String rootPath, Collection<File> filesToDelete, boolean addProjectRoots) throws Exception {
        File dir = FileUtil.createTempDirectory("unitTest", null);
        filesToDelete.add(dir);
        VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir.getCanonicalPath().replace(File.separatorChar, '/'));
        if (rootPath != null) {
            VirtualFile vDir1 = LocalFileSystem.getInstance().findFileByPath(rootPath.replace(File.separatorChar, '/'));
            if (vDir1 == null) {
                throw new Exception(rootPath + " not found");
            }
            VfsUtil.copyDirectory(null, vDir1, vDir, null);
        }
        if (addProjectRoots) {
            PsiTestUtil.addSourceContentToRoots(module, vDir);
        }
        return vDir;
    }

    public static void removeAllRoots(Module module, ProjectJdk jdk) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance(module);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        rootModel.clear();
        rootModel.setJdk(jdk);
        rootModel.commit();
    }

    public static void addSourceContentToRoots(Module module, VirtualFile vDir) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance(module);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        ContentEntry contentEntry = rootModel.addContentEntry(vDir);
        contentEntry.addSourceFolder(vDir, false);
        rootModel.commit();
    }

    public static void addSourceRoot(Module module, VirtualFile vDir) {
        PsiTestUtil.addSourceRoot(module, vDir, false);
    }

    public static void addSourceRoot(Module module, final VirtualFile vDir, boolean isTestSource) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance(module);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        ContentEntry[] contentEntries = rootModel.getContentEntries();
        ContentEntry entry = ContainerUtil.find(contentEntries, new Condition<ContentEntry>(){

            @Override
            public boolean value(ContentEntry object) {
                return VfsUtil.isAncestor(object.getFile(), vDir, false);
            }
        });
        if (entry == null) {
            entry = rootModel.addContentEntry(vDir);
        }
        entry.addSourceFolder(vDir, isTestSource);
        rootModel.commit();
    }

    public static ContentEntry addContentRoot(Module module, VirtualFile vDir) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance(module);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        ContentEntry e = rootModel.addContentEntry(vDir);
        rootModel.commit();
        return e;
    }

    public static void removeContentEntry(Module m, ContentEntry e) {
        ModuleRootManager rootModel = ModuleRootManager.getInstance(m);
        ModifiableRootModel model = rootModel.getModifiableModel();
        model.removeContentEntry(e);
        model.commit();
    }

    public static void checkFileStructure(PsiFile file) throws IncorrectOperationException {
        String originalTree = DebugUtil.psiTreeToString((PsiElement)file, (boolean)false);
        PsiElementFactory factory = file.getManager().getElementFactory();
        PsiFile dummyFile = factory.createFileFromText(file.getName(), file.getText());
        String reparsedTree = DebugUtil.psiTreeToString((PsiElement)dummyFile, (boolean)false);
        Assert.assertEquals((String)reparsedTree, (String)originalTree);
    }

    public static void addLibrary(final Module module, final String libName, final String libPath, final String ... jarArr) {
        assert (ModuleRootManager.getInstance(module).getContentRoots().length > 0) : "content roots must not be empty";
        new WriteCommandAction(module.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                ModifiableRootModel model = ModuleRootManager.getInstance(module).getModifiableModel();
                LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)module.getProject());
                Library library = libraryTable.createLibrary(libName);
                Library.ModifiableModel libraryModel = library.getModifiableModel();
                for (String jar : jarArr) {
                    String path = libPath + jar;
                    String newPath = model.getContentRoots()[0].getPath() + "/" + jar;
                    FileUtil.copy(new File(path), new File(newPath));
                    VirtualFile root = JarFileSystem.getInstance().refreshAndFindFileByPath(newPath + "!/");
                    assert (root != null);
                    libraryModel.addRoot(root, OrderRootType.CLASSES);
                }
                libraryModel.commit();
                model.addLibraryEntry(library);
                OrderEntry[] orderEntries = model.getOrderEntries();
                OrderEntry last = orderEntries[orderEntries.length - 1];
                for (int i = orderEntries.length - 2; i > -1; --i) {
                    orderEntries[i + 1] = orderEntries[i];
                }
                orderEntries[0] = last;
                model.rearrangeOrderEntries(orderEntries);
                model.commit();
            }
        }.execute();
    }
}

