/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.testFramework.ModuleTestCase;
import com.intellij.testFramework.PsiTestData;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public abstract class PsiTestCase
extends ModuleTestCase {
    protected PsiManagerImpl myPsiManager;
    protected PsiFile myFile;
    protected PsiTestData myTestDataBefore;
    protected PsiTestData myTestDataAfter;
    private String myDataRoot;

    protected void setUp() throws Exception {
        super.setUp();
        this.myPsiManager = (PsiManagerImpl)PsiManager.getInstance(this.myProject);
    }

    protected void tearDown() throws Exception {
        this.myPsiManager = null;
        this.myFile = null;
        this.myTestDataBefore = null;
        this.myTestDataAfter = null;
        super.tearDown();
    }

    protected PsiFile createDummyFile(String fileName, String text) throws IncorrectOperationException {
        return this.myPsiManager.getElementFactory().createFileFromText(fileName, text);
    }

    protected PsiFile createFile(@NonNls String fileName, String text) throws Exception {
        return this.createFile(this.myModule, fileName, text);
    }

    protected PsiFile createFile(Module module, String fileName, String text) throws Exception {
        File dir = PsiTestCase.createTempDir("unitTest");
        VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir.getCanonicalPath().replace(File.separatorChar, '/'));
        return this.createFile(module, vDir, fileName, text);
    }

    protected PsiFile createFile(Module module, VirtualFile vDir, String fileName, String text) throws IOException {
        if (!ModuleRootManager.getInstance(module).getFileIndex().isInSourceContent(vDir)) {
            this.addSourceContentToRoots(module, vDir);
        }
        VirtualFile vFile = vDir.createChildData(vDir, fileName);
        VfsUtil.saveText(vFile, text);
        PsiTestCase.assertNotNull((Object)vFile);
        PsiFile file = this.myPsiManager.findFile(vFile);
        PsiTestCase.assertNotNull((Object)file);
        return file;
    }

    protected void addSourceContentToRoots(Module module, VirtualFile vDir) {
        PsiTestUtil.addSourceContentToRoots(module, vDir);
    }

    protected PsiElement configureByFileWithMarker(String filePath, String marker) throws Exception {
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(filePath.replace(File.separatorChar, '/'));
        PsiTestCase.assertNotNull((String)("file " + filePath + " not found"), (Object)vFile);
        String fileText = VfsUtil.loadText(vFile);
        fileText = StringUtil.convertLineSeparators(fileText, "\n");
        int offset = fileText.indexOf(marker);
        PsiTestCase.assertTrue((offset >= 0 ? 1 : 0) != 0);
        fileText = fileText.substring(0, offset) + fileText.substring(offset + marker.length());
        this.myFile = this.createFile(vFile.getName(), fileText);
        return this.myFile.findElementAt(offset);
    }

    protected void configure(String path, String dataName) throws Exception {
        this.myDataRoot = PathManagerEx.getTestDataPath() + path;
        this.myTestDataBefore = this.loadData(dataName);
        PsiTestUtil.removeAllRoots(this.myModule, JavaSdkImpl.getMockJdk((String)"java 1.4"));
        VirtualFile vDir = PsiTestUtil.createTestProjectStructure(this.myProject, this.myModule, this.myDataRoot, myFilesToDelete);
        VirtualFile vFile = vDir.findChild(this.myTestDataBefore.getTextFile());
        this.myFile = this.myPsiManager.findFile(vFile);
    }

    private PsiTestData loadData(String dataName) throws Exception {
        org.jdom.Document document = JDOMUtil.loadDocument(new File(this.myDataRoot + "/" + "data.xml"));
        PsiTestData data = this.createData();
        Element documentElement = document.getRootElement();
        List nodes = documentElement.getChildren("data");
        for (int i = 0; i < nodes.size(); ++i) {
            Element node = (Element)nodes.get(i);
            String value = node.getAttributeValue("name");
            if (!value.equals(dataName)) continue;
            DefaultJDOMExternalizer.readExternal(data, node);
            data.loadText(this.myDataRoot);
            return data;
        }
        throw new IllegalArgumentException("Cannot find data chunk '" + dataName + "'");
    }

    protected PsiTestData createData() {
        return new PsiTestData();
    }

    protected void checkResult(String dataName) throws Exception {
        String actualText;
        this.myTestDataAfter = this.loadData(dataName);
        String textExpected = this.myTestDataAfter.getText();
        if (!textExpected.equals(actualText = this.myFile.getText())) {
            System.out.println("Text mismatch: " + this.getName() + "(" + this.getClass().getName() + ")");
            System.out.println("Text expected:");
            PsiTestCase.printText(textExpected);
            System.out.println("Text found:");
            PsiTestCase.printText(actualText);
            PsiTestCase.assertTrue((String)"text", (boolean)false);
        }
    }

    protected static void printText(String text) {
        String q = "\"";
        System.out.print("\"");
        text = StringUtil.convertLineSeparators(text, "\n");
        StringTokenizer tokenizer = new StringTokenizer(text, "\n", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\n")) {
                System.out.print("\"");
                System.out.println();
                System.out.print("\"");
                continue;
            }
            System.out.print(token);
        }
        System.out.print("\"");
        System.out.println();
    }

    protected void addLibraryToRoots(VirtualFile jarFile, OrderRootType rootType) {
        PsiTestCase.addLibraryToRoots(this.myModule, jarFile, rootType);
    }

    protected static void addLibraryToRoots(Module module, VirtualFile jarFile, OrderRootType rootType) {
        ModuleRootManager manager = ModuleRootManager.getInstance(module);
        ModifiableRootModel rootModel = manager.getModifiableModel();
        Library jarLibrary = rootModel.getModuleLibraryTable().createLibrary();
        Library.ModifiableModel libraryModel = jarLibrary.getModifiableModel();
        libraryModel.addRoot(jarFile, rootType);
        libraryModel.commit();
        rootModel.commit();
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public Document getDocument(PsiFile file) {
        return PsiDocumentManager.getInstance(this.getProject()).getDocument(file);
    }

    public void commitDocument(Document document) {
        PsiDocumentManager.getInstance(this.getProject()).commitDocument(document);
    }
}

