/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.jsp.JspFile;
import com.intellij.testFramework.LightIdeaTestCase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public abstract class ParsingTestCase
extends LightIdeaTestCase {
    protected String myFileExt;
    @NonNls
    private final String myFullDataPath;
    protected PsiFile myFile;

    public ParsingTestCase(String dataPath, String fileExt) {
        this.myFullDataPath = this.getTestDataPath() + "/psi/" + dataPath;
        this.myFileExt = fileExt;
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    protected void doTest(boolean checkResult) throws Exception {
        String name = this.getTestName(false);
        String text = this.loadFile(name + "." + this.myFileExt);
        this.myFile = ParsingTestCase.createFile(name + "." + this.myFileExt, text);
        this.myFile.accept(new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }
        });
        ParsingTestCase.assertEquals((String)text, (String)this.myFile.getText());
        if (checkResult) {
            this.checkResult(name + ".txt", this.myFile);
        } else {
            ParsingTestCase.toParseTreeText(this.myFile);
        }
        if (this.myFile instanceof JspFile) {
            ((MultiplePsiFilesPerDocumentFileViewProvider)((JspFile)this.myFile).getViewProvider()).checkAllTreesEqual();
        }
    }

    protected void checkResult(@NonNls String targetDataName, PsiFile file) throws Exception {
        ParsingTestCase.doCheckResult(this.myFullDataPath, file, targetDataName);
    }

    public static void doCheckResult(String myFullDataPath, PsiFile file, String targetDataName) throws Exception {
        PsiFile[] psiRoots = file.getPsiRoots();
        if (psiRoots.length > 1) {
            for (int i = 0; i < psiRoots.length; ++i) {
                PsiFile psiRoot = psiRoots[i];
                ParsingTestCase.doCheckResult(myFullDataPath, targetDataName + "." + i, ParsingTestCase.toParseTreeText(psiRoot).trim());
            }
        } else {
            ParsingTestCase.doCheckResult(myFullDataPath, targetDataName, ParsingTestCase.toParseTreeText(file).trim());
        }
    }

    protected void checkResult(String targetDataName, String text) throws Exception {
        ParsingTestCase.doCheckResult(this.myFullDataPath, targetDataName, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCheckResult(String myFullDataPath, String targetDataName, String text) throws Exception {
        try {
            String expectedText = ParsingTestCase.doLoadFile(myFullDataPath, targetDataName);
            ParsingTestCase.assertEquals((String)expectedText, (String)text);
        }
        catch (FileNotFoundException e) {
            String fullName = myFullDataPath + File.separatorChar + targetDataName;
            FileWriter writer = new FileWriter(fullName);
            try {
                writer.write(text);
            }
            finally {
                writer.close();
            }
            ParsingTestCase.fail((String)("No output text found. File " + fullName + " created."));
        }
    }

    protected static String toParseTreeText(PsiElement file) {
        return DebugUtil.psiToString((PsiElement)file, (boolean)false);
    }

    protected String loadFile(String name) throws Exception {
        return ParsingTestCase.doLoadFile(this.myFullDataPath, name);
    }

    private static String doLoadFile(String myFullDataPath, String name) throws IOException {
        String fullName = myFullDataPath + File.separatorChar + name;
        String text = new String(FileUtil.loadFileText(new File(fullName))).trim();
        text = StringUtil.convertLineSeparators(text);
        return text;
    }
}

