/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.IdeaTestCase;
import com.intellij.testFramework.PsiTestUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleTestCase
extends IdeaTestCase {
    protected final Collection<Module> myModulesToDispose = new ArrayList<Module>();

    protected void setUp() throws Exception {
        super.setUp();
        this.myModulesToDispose.clear();
    }

    protected void tearDown() throws Exception {
        final ModuleManager moduleManager = ModuleManager.getInstance(this.myProject);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            public void run() {
                for (Module module : ModuleTestCase.this.myModulesToDispose) {
                    String moduleName = module.getName();
                    if (moduleManager.findModuleByName(moduleName) == null) continue;
                    moduleManager.disposeModule(module);
                }
            }
        });
        this.myModulesToDispose.clear();
        super.tearDown();
    }

    protected Module createModule(File moduleFile) {
        return this.createModule(moduleFile, ModuleType.JAVA);
    }

    protected Module createModule(File moduleFile, ModuleType moduleType) {
        String path = moduleFile.getAbsolutePath();
        return this.createModule(path, moduleType);
    }

    protected Module createModule(String path) {
        return this.createModule(path, ModuleType.JAVA);
    }

    protected Module createModule(final String path, final ModuleType moduleType) {
        Module module = ApplicationManager.getApplication().runWriteAction(new Computable<Module>(){

            @Override
            public Module compute() {
                return ModuleManager.getInstance(ModuleTestCase.this.myProject).newModule(path, moduleType);
            }
        });
        this.myModulesToDispose.add(module);
        return module;
    }

    protected Module loadModule(final File moduleFile) {
        Module module = ApplicationManager.getApplication().runWriteAction(new Computable<Module>(){

            @Override
            public Module compute() {
                try {
                    return ModuleManager.getInstance(ModuleTestCase.this.myProject).loadModule(moduleFile.getAbsolutePath());
                }
                catch (Exception e) {
                    IdeaTestCase.LOG.error(e);
                    return null;
                }
            }
        });
        this.myModulesToDispose.add(module);
        return module;
    }

    public Module loadModule(String modulePath, Project project) throws InvalidDataException, IOException, JDOMException {
        return this.loadModule(new File(modulePath));
    }

    @Nullable
    protected ModuleImpl loadAllModulesUnder(VirtualFile rootDir) throws Exception {
        VirtualFile[] children;
        ModuleImpl module = null;
        for (VirtualFile child : children = rootDir.getChildren()) {
            if (child.isDirectory()) {
                ModuleImpl childModule = this.loadAllModulesUnder(child);
                if (module != null) continue;
                module = childModule;
                continue;
            }
            if (!child.getName().endsWith(".iml")) continue;
            String modulePath = child.getPath();
            module = (ModuleImpl)this.loadModule(new File(modulePath));
            this.readJdomExternalizables(module);
        }
        return module;
    }

    protected void readJdomExternalizables(ModuleImpl module) {
        ProjectImpl project = (ProjectImpl)this.myProject;
        project.setOptimiseTestLoadSpeed(false);
        ModuleRootManagerImpl moduleRootManager = (ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module);
        module.getStateStore().initComponent((Object)moduleRootManager);
        project.setOptimiseTestLoadSpeed(true);
    }

    protected Module createModuleFromTestData(String dirInTestData, String newModuleFileName, ModuleType moduleType) throws IOException {
        File dirInTestDataFile = new File(dirInTestData);
        ModuleTestCase.assertTrue((boolean)dirInTestDataFile.isDirectory());
        File moduleDir = this.createTempDirectory();
        FileUtil.copyDir(dirInTestDataFile, moduleDir);
        Module module = this.createModule(moduleDir + "/" + newModuleFileName, moduleType);
        PsiTestUtil.addContentRoot(module, LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleDir));
        return module;
    }
}

